/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v818.serializer;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v486.serializer.SubChunkSerializer_v486;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.HeightMapDataType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.SubChunkData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.SubChunkRequestResult;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.SubChunkPacket;
import io.netty.buffer.ByteBuf;

public class SubChunkSerializer_v818
extends SubChunkSerializer_v486 {
    public static final SubChunkSerializer_v818 INSTANCE = new SubChunkSerializer_v818();

    @Override
    protected void serializeSubChunk(ByteBuf buffer, BedrockCodecHelper helper, SubChunkPacket packet, SubChunkData subChunk) {
        this.writeSubChunkOffset(buffer, subChunk.getPosition());
        buffer.writeByte(subChunk.getResult().ordinal());
        if (subChunk.getResult() != SubChunkRequestResult.SUCCESS_ALL_AIR || !packet.isCacheEnabled()) {
            helper.writeByteBuf(buffer, subChunk.getData());
        }
        buffer.writeByte(subChunk.getHeightMapType().ordinal());
        if (subChunk.getHeightMapType() == HeightMapDataType.HAS_DATA) {
            ByteBuf heightMapBuf = subChunk.getHeightMapData();
            buffer.writeBytes(heightMapBuf, heightMapBuf.readerIndex(), 256);
        }
        buffer.writeByte(subChunk.getRenderHeightMapType().ordinal());
        if (subChunk.getRenderHeightMapType() == HeightMapDataType.HAS_DATA) {
            ByteBuf renderHeightMapBuf = subChunk.getRenderHeightMapData();
            buffer.writeBytes(renderHeightMapBuf, renderHeightMapBuf.readerIndex(), 256);
        }
        if (packet.isCacheEnabled()) {
            buffer.writeLongLE(subChunk.getBlobId());
        }
    }

    @Override
    protected SubChunkData deserializeSubChunk(ByteBuf buffer, BedrockCodecHelper helper, SubChunkPacket packet) {
        SubChunkData subChunk = new SubChunkData();
        subChunk.setPosition(this.readSubChunkOffset(buffer));
        subChunk.setResult(SubChunkRequestResult.values()[buffer.readByte()]);
        if (subChunk.getResult() != SubChunkRequestResult.SUCCESS_ALL_AIR || !packet.isCacheEnabled()) {
            subChunk.setData(helper.readByteBuf(buffer));
        }
        subChunk.setHeightMapType(HeightMapDataType.values()[buffer.readByte()]);
        if (subChunk.getHeightMapType() == HeightMapDataType.HAS_DATA) {
            subChunk.setHeightMapData(buffer.readRetainedSlice(256));
        }
        subChunk.setRenderHeightMapType(HeightMapDataType.values()[buffer.readByte()]);
        if (subChunk.getRenderHeightMapType() == HeightMapDataType.HAS_DATA) {
            subChunk.setRenderHeightMapData(buffer.readRetainedSlice(256));
        }
        if (packet.isCacheEnabled()) {
            subChunk.setBlobId(buffer.readLongLE());
        }
        return subChunk;
    }
}

