/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.skin;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.skin.AnimatedTextureType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.skin.AnimationExpressionType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.skin.ImageData;

public final class AnimationData {
    private final ImageData image;
    private final AnimatedTextureType textureType;
    private final float frames;
    private final AnimationExpressionType expressionType;

    public AnimationData(ImageData image, AnimatedTextureType textureType, float frames) {
        this.image = image;
        this.textureType = textureType;
        this.frames = frames;
        this.expressionType = AnimationExpressionType.LINEAR;
    }

    public ImageData getImage() {
        return this.image;
    }

    public AnimatedTextureType getTextureType() {
        return this.textureType;
    }

    public float getFrames() {
        return this.frames;
    }

    public AnimationExpressionType getExpressionType() {
        return this.expressionType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnimationData)) {
            return false;
        }
        AnimationData other = (AnimationData)o;
        if (Float.compare(this.getFrames(), other.getFrames()) != 0) {
            return false;
        }
        ImageData this$image = this.getImage();
        ImageData other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        AnimatedTextureType this$textureType = this.getTextureType();
        AnimatedTextureType other$textureType = other.getTextureType();
        if (this$textureType == null ? other$textureType != null : !((Object)((Object)this$textureType)).equals((Object)other$textureType)) {
            return false;
        }
        AnimationExpressionType this$expressionType = this.getExpressionType();
        AnimationExpressionType other$expressionType = other.getExpressionType();
        return !(this$expressionType == null ? other$expressionType != null : !((Object)((Object)this$expressionType)).equals((Object)other$expressionType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getFrames());
        ImageData $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        AnimatedTextureType $textureType = this.getTextureType();
        result = result * 59 + ($textureType == null ? 43 : ((Object)((Object)$textureType)).hashCode());
        AnimationExpressionType $expressionType = this.getExpressionType();
        result = result * 59 + ($expressionType == null ? 43 : ((Object)((Object)$expressionType)).hashCode());
        return result;
    }

    public String toString() {
        return "AnimationData(image=" + this.getImage() + ", textureType=" + (Object)((Object)this.getTextureType()) + ", frames=" + this.getFrames() + ", expressionType=" + (Object)((Object)this.getExpressionType()) + ")";
    }

    public AnimationData(ImageData image, AnimatedTextureType textureType, float frames, AnimationExpressionType expressionType) {
        this.image = image;
        this.textureType = textureType;
        this.frames = frames;
        this.expressionType = expressionType;
    }
}

