/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.exceptions;

import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.asm.Type;
import oxy.geyser.reversion.shaded.asm.tree.ClassNode;
import oxy.geyser.reversion.shaded.asm.tree.FieldNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodNode;
import oxy.geyser.reversion.shaded.classtransform.utils.Codifier;
import oxy.geyser.reversion.shaded.classtransform.utils.Types;

@ParametersAreNonnullByDefault
public class TransformerException
extends RuntimeException {
    private final String memberType;
    private final String memberNameAndDesc;
    private final String transformerName;
    private final String state;
    private String help;

    public static TransformerException wrongStaticAccess(MethodNode transformerMethod, ClassNode transformer, boolean shouldBeStatic) {
        return new TransformerException(transformerMethod, transformer, "must " + (shouldBeStatic ? "" : "not ") + "be static").help(Codifier.of(transformerMethod).access(shouldBeStatic ? transformerMethod.access | 8 : transformerMethod.access & 0xFFFFFFF7));
    }

    public static TransformerException mustReturnVoid(MethodNode transformerMethod, ClassNode transformer) {
        return new TransformerException(transformerMethod, transformer, "must return 'void'").help(Codifier.of(transformerMethod).returnType(Type.VOID_TYPE));
    }

    public static TransformerException wrongArguments(MethodNode transformerMethod, ClassNode transformer, Class<?> ... expected) {
        Type[] argTypes = new Type[expected.length];
        for (int i = 0; i < expected.length; ++i) {
            argTypes[i] = Types.type(expected[i]);
        }
        return TransformerException.wrongArguments(transformerMethod, transformer, argTypes);
    }

    public static TransformerException wrongArguments(MethodNode transformerMethod, ClassNode transformer, Type ... expected) {
        String expectedArgs = "must have ";
        if (expected.length == 0) {
            expectedArgs = expectedArgs + "no arguments";
        } else {
            expectedArgs = expectedArgs + "the following argument";
            if (expected.length != 1) {
                expectedArgs = expectedArgs + "s";
            }
        }
        throw new TransformerException(transformerMethod, transformer, expectedArgs).help(Codifier.of(transformerMethod).param(null).params(expected));
    }

    public static TransformerException alreadyExists(MethodNode method, ClassNode transformer, ClassNode transformedClass) {
        return new TransformerException(method, transformer, "already exists in class '" + transformedClass.name + "'");
    }

    public static TransformerException alreadyExists(FieldNode field, ClassNode transformer, ClassNode transformedClass) {
        return new TransformerException(field, transformer, "already exists in class '" + transformedClass.name + "'");
    }

    public TransformerException(FieldNode field, ClassNode transformer, String state) {
        this.memberType = "Field";
        this.memberNameAndDesc = field.name + ":" + field.desc;
        this.transformerName = transformer.name;
        this.state = state;
    }

    public TransformerException(MethodNode method, ClassNode transformer, String state) {
        this.memberType = "Method";
        this.memberNameAndDesc = method.name + method.desc;
        this.transformerName = transformer.name;
        this.state = state;
    }

    public TransformerException setCause(Throwable cause) {
        this.initCause(cause);
        return this;
    }

    public TransformerException help(Codifier codifier) {
        return this.help(codifier.build());
    }

    public TransformerException help(String help) {
        this.help = help;
        return this;
    }

    @Override
    public String getMessage() {
        String message = this.memberType + " '" + this.memberNameAndDesc + "' in transformer '" + this.transformerName + "' " + this.state;
        if (this.help != null) {
            message = message + ": " + this.help;
        }
        return message;
    }
}

