/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.mappings.impl.special;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import lombok.Generated;
import oxy.geyser.reversion.shaded.classtransform.mappings.MapperConfig;
import oxy.geyser.reversion.shaded.classtransform.mappings.impl.TinyV2Mapper;
import oxy.geyser.reversion.shaded.classtransform.utils.mappings.MapRemapper;

@ParametersAreNonnullByDefault
public class MetaTinyV2Mapper
extends TinyV2Mapper {
    private final MapRemapper descriptorMapper = new MapRemapper();
    private final List<ClassMetadata> metadata = new ArrayList<ClassMetadata>();
    private ClassMetadata currentClassMetadata = null;
    private FieldMetadata currentFieldMetadata = null;
    private MethodMetadata currentMethodMetadata = null;
    private ParameterMetadata currentParameterMetadata = null;

    public MetaTinyV2Mapper(MapperConfig config, @WillClose InputStream mappingsStream, String from, String to) {
        super(config, mappingsStream, from, to);
    }

    public MetaTinyV2Mapper(MapperConfig config, File mappingsFile, String from, String to) {
        super(config, mappingsFile, from, to);
    }

    public List<ClassMetadata> getMetadata() {
        return this.metadata;
    }

    @Override
    protected void classParsed(String baseName, String fromName, String toName) {
        this.descriptorMapper.addClassMapping(baseName, toName);
        this.updateMetadata(UpdateLevel.CLASS);
        this.currentClassMetadata = new ClassMetadata(toName, null, new ArrayList<FieldMetadata>(), new ArrayList<MethodMetadata>());
    }

    @Override
    protected void fieldParsed(@Nullable String currentClass, String fromName, String toName, String descriptor) {
        if (this.currentClassMetadata == null) {
            throw new IllegalStateException("Field mapping without class mapping");
        }
        this.updateMetadata(UpdateLevel.FIELD);
        this.currentFieldMetadata = new FieldMetadata(toName, descriptor, null);
    }

    @Override
    protected void methodParsed(@Nullable String currentClass, String fromName, String toName, String descriptor) {
        if (this.currentClassMetadata == null) {
            throw new IllegalStateException("Method mapping without class mapping");
        }
        this.updateMetadata(UpdateLevel.METHOD);
        this.currentMethodMetadata = new MethodMetadata(toName, descriptor, null, new ArrayList<ParameterMetadata>());
    }

    @Override
    protected void parseParameter(@Nullable String currentClass, String[] parts) {
        if (this.currentMethodMetadata == null) {
            throw new IllegalStateException("Parameter mapping without method mapping");
        }
        int index = Integer.parseInt(parts[1]);
        String name = parts[2];
        this.updateMetadata(UpdateLevel.PARAMETER);
        this.currentParameterMetadata = new ParameterMetadata(index, name, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void parseComment(@Nullable String currentClass, String line, String[] parts) {
        if (line.startsWith("\t\t\t")) {
            if (this.currentParameterMetadata == null) {
                throw new IllegalStateException("Comment without parameter mapping");
            }
            this.currentParameterMetadata = this.currentParameterMetadata.withComment(String.join((CharSequence)"\t", Arrays.copyOfRange(parts, 1, parts.length)));
            return;
        } else if (line.startsWith("\t\t")) {
            if (this.currentFieldMetadata != null && this.currentMethodMetadata != null) {
                throw new IllegalStateException("Field and method metadata at the same time");
            }
            if (this.currentFieldMetadata != null) {
                this.currentFieldMetadata = this.currentFieldMetadata.withComment(String.join((CharSequence)"\t", Arrays.copyOfRange(parts, 1, parts.length)));
                return;
            } else {
                if (this.currentMethodMetadata == null) throw new IllegalStateException("Comment without field or method mapping");
                this.currentMethodMetadata = this.currentMethodMetadata.withComment(String.join((CharSequence)"\t", Arrays.copyOfRange(parts, 1, parts.length)));
            }
            return;
        } else {
            if (!line.startsWith("\t")) throw new IllegalStateException("Unknown line: " + line);
            if (this.currentClassMetadata == null) {
                throw new IllegalStateException("Comment without class mapping");
            }
            this.currentClassMetadata = this.currentClassMetadata.withComment(String.join((CharSequence)"\t", Arrays.copyOfRange(parts, 1, parts.length)));
        }
    }

    @Override
    protected void postInit(MapRemapper descriptorRemapper) {
        this.updateMetadata(UpdateLevel.CLASS);
        ArrayList<ClassMetadata> remappedMetadata = new ArrayList<ClassMetadata>();
        for (ClassMetadata classMetadata : this.metadata) {
            classMetadata = classMetadata.withName(this.remapper.mapSafe(classMetadata.getName()));
            remappedMetadata.add(classMetadata);
            ArrayList<FieldMetadata> remappedFields = new ArrayList<FieldMetadata>();
            for (FieldMetadata field : classMetadata.fields) {
                remappedFields.add(field.withDescriptor(this.descriptorMapper.mapDesc(field.getDescriptor())));
            }
            classMetadata.fields.clear();
            classMetadata.fields.addAll(remappedFields);
            ArrayList<MethodMetadata> remappedMethods = new ArrayList<MethodMetadata>();
            for (MethodMetadata method : classMetadata.methods) {
                remappedMethods.add(method.withDescriptor(this.descriptorMapper.mapMethodDesc(method.getDescriptor())));
            }
            classMetadata.methods.clear();
            classMetadata.methods.addAll(remappedMethods);
        }
        this.metadata.clear();
        this.metadata.addAll(remappedMetadata);
    }

    private void updateMetadata(UpdateLevel level) {
        UpdateLevel[] updates;
        switch (level) {
            case CLASS: {
                updates = new UpdateLevel[]{UpdateLevel.PARAMETER, UpdateLevel.METHOD, UpdateLevel.FIELD, UpdateLevel.CLASS};
                break;
            }
            case FIELD: 
            case METHOD: {
                updates = new UpdateLevel[]{UpdateLevel.PARAMETER, UpdateLevel.METHOD, UpdateLevel.FIELD};
                break;
            }
            case PARAMETER: {
                updates = new UpdateLevel[]{UpdateLevel.PARAMETER};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update level: " + (Object)((Object)level));
            }
        }
        block11: for (UpdateLevel update : updates) {
            switch (update) {
                case CLASS: {
                    if (this.currentClassMetadata != null && !this.currentClassMetadata.isEmpty()) {
                        this.metadata.add(this.currentClassMetadata);
                    }
                    this.currentClassMetadata = null;
                    continue block11;
                }
                case FIELD: {
                    if (this.currentFieldMetadata != null && !this.currentFieldMetadata.isEmpty()) {
                        this.currentClassMetadata.getFields().add(this.currentFieldMetadata);
                    }
                    this.currentFieldMetadata = null;
                    continue block11;
                }
                case METHOD: {
                    if (this.currentMethodMetadata != null && !this.currentMethodMetadata.isEmpty()) {
                        this.currentClassMetadata.getMethods().add(this.currentMethodMetadata);
                    }
                    this.currentMethodMetadata = null;
                    continue block11;
                }
                case PARAMETER: {
                    if (this.currentParameterMetadata != null) {
                        this.currentMethodMetadata.getParameters().add(this.currentParameterMetadata);
                    }
                    this.currentParameterMetadata = null;
                }
            }
        }
    }

    private static enum UpdateLevel {
        CLASS,
        FIELD,
        METHOD,
        PARAMETER;

    }

    public static class ParameterMetadata {
        private final int index;
        private final String name;
        @Nullable
        private final String comment;

        @Generated
        public ParameterMetadata(int index, String name, @Nullable String comment) {
            this.index = index;
            this.name = name;
            this.comment = comment;
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Nullable
        @Generated
        public String getComment() {
            return this.comment;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterMetadata)) {
                return false;
            }
            ParameterMetadata other = (ParameterMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParameterMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetaTinyV2Mapper.ParameterMetadata(index=" + this.getIndex() + ", name=" + this.getName() + ", comment=" + this.getComment() + ")";
        }

        @Generated
        public ParameterMetadata withIndex(int index) {
            return this.index == index ? this : new ParameterMetadata(index, this.name, this.comment);
        }

        @Generated
        public ParameterMetadata withName(String name) {
            return this.name == name ? this : new ParameterMetadata(this.index, name, this.comment);
        }

        @Generated
        public ParameterMetadata withComment(@Nullable String comment) {
            return this.comment == comment ? this : new ParameterMetadata(this.index, this.name, comment);
        }
    }

    public static class MethodMetadata {
        private final String name;
        private final String descriptor;
        @Nullable
        private final String comment;
        private final List<ParameterMetadata> parameters;

        public boolean isEmpty() {
            return this.comment == null && this.parameters.isEmpty();
        }

        @Generated
        public MethodMetadata(String name, String descriptor, @Nullable String comment, List<ParameterMetadata> parameters) {
            this.name = name;
            this.descriptor = descriptor;
            this.comment = comment;
            this.parameters = parameters;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescriptor() {
            return this.descriptor;
        }

        @Nullable
        @Generated
        public String getComment() {
            return this.comment;
        }

        @Generated
        public List<ParameterMetadata> getParameters() {
            return this.parameters;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodMetadata)) {
                return false;
            }
            MethodMetadata other = (MethodMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$descriptor = this.getDescriptor();
            String other$descriptor = other.getDescriptor();
            if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            List<ParameterMetadata> this$parameters = this.getParameters();
            List<ParameterMetadata> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MethodMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $descriptor = this.getDescriptor();
            result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            List<ParameterMetadata> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetaTinyV2Mapper.MethodMetadata(name=" + this.getName() + ", descriptor=" + this.getDescriptor() + ", comment=" + this.getComment() + ", parameters=" + this.getParameters() + ")";
        }

        @Generated
        public MethodMetadata withName(String name) {
            return this.name == name ? this : new MethodMetadata(name, this.descriptor, this.comment, this.parameters);
        }

        @Generated
        public MethodMetadata withDescriptor(String descriptor) {
            return this.descriptor == descriptor ? this : new MethodMetadata(this.name, descriptor, this.comment, this.parameters);
        }

        @Generated
        public MethodMetadata withComment(@Nullable String comment) {
            return this.comment == comment ? this : new MethodMetadata(this.name, this.descriptor, comment, this.parameters);
        }

        @Generated
        public MethodMetadata withParameters(List<ParameterMetadata> parameters) {
            return this.parameters == parameters ? this : new MethodMetadata(this.name, this.descriptor, this.comment, parameters);
        }
    }

    public static class FieldMetadata {
        private final String name;
        private final String descriptor;
        @Nullable
        private final String comment;

        public boolean isEmpty() {
            return this.comment == null;
        }

        @Generated
        public FieldMetadata(String name, String descriptor, @Nullable String comment) {
            this.name = name;
            this.descriptor = descriptor;
            this.comment = comment;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescriptor() {
            return this.descriptor;
        }

        @Nullable
        @Generated
        public String getComment() {
            return this.comment;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldMetadata)) {
                return false;
            }
            FieldMetadata other = (FieldMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$descriptor = this.getDescriptor();
            String other$descriptor = other.getDescriptor();
            if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FieldMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $descriptor = this.getDescriptor();
            result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetaTinyV2Mapper.FieldMetadata(name=" + this.getName() + ", descriptor=" + this.getDescriptor() + ", comment=" + this.getComment() + ")";
        }

        @Generated
        public FieldMetadata withName(String name) {
            return this.name == name ? this : new FieldMetadata(name, this.descriptor, this.comment);
        }

        @Generated
        public FieldMetadata withDescriptor(String descriptor) {
            return this.descriptor == descriptor ? this : new FieldMetadata(this.name, descriptor, this.comment);
        }

        @Generated
        public FieldMetadata withComment(@Nullable String comment) {
            return this.comment == comment ? this : new FieldMetadata(this.name, this.descriptor, comment);
        }
    }

    public static class ClassMetadata {
        private final String name;
        @Nullable
        private final String comment;
        private final List<FieldMetadata> fields;
        private final List<MethodMetadata> methods;

        public boolean isEmpty() {
            return this.comment == null && this.fields.stream().allMatch(FieldMetadata::isEmpty) && this.methods.stream().allMatch(MethodMetadata::isEmpty);
        }

        @Generated
        public ClassMetadata(String name, @Nullable String comment, List<FieldMetadata> fields, List<MethodMetadata> methods) {
            this.name = name;
            this.comment = comment;
            this.fields = fields;
            this.methods = methods;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Nullable
        @Generated
        public String getComment() {
            return this.comment;
        }

        @Generated
        public List<FieldMetadata> getFields() {
            return this.fields;
        }

        @Generated
        public List<MethodMetadata> getMethods() {
            return this.methods;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassMetadata)) {
                return false;
            }
            ClassMetadata other = (ClassMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            List<FieldMetadata> this$fields = this.getFields();
            List<FieldMetadata> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            List<MethodMetadata> this$methods = this.getMethods();
            List<MethodMetadata> other$methods = other.getMethods();
            return !(this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClassMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            List<FieldMetadata> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            List<MethodMetadata> $methods = this.getMethods();
            result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetaTinyV2Mapper.ClassMetadata(name=" + this.getName() + ", comment=" + this.getComment() + ", fields=" + this.getFields() + ", methods=" + this.getMethods() + ")";
        }

        @Generated
        public ClassMetadata withName(String name) {
            return this.name == name ? this : new ClassMetadata(name, this.comment, this.fields, this.methods);
        }

        @Generated
        public ClassMetadata withComment(@Nullable String comment) {
            return this.comment == comment ? this : new ClassMetadata(this.name, comment, this.fields, this.methods);
        }

        @Generated
        public ClassMetadata withFields(List<FieldMetadata> fields) {
            return this.fields == fields ? this : new ClassMetadata(this.name, this.comment, fields, this.methods);
        }

        @Generated
        public ClassMetadata withMethods(List<MethodMetadata> methods) {
            return this.methods == methods ? this : new ClassMetadata(this.name, this.comment, this.fields, methods);
        }
    }
}

