/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.targets.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.asm.Type;
import oxy.geyser.reversion.shaded.asm.tree.AbstractInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.ClassNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodNode;
import oxy.geyser.reversion.shaded.classtransform.TransformerManager;
import oxy.geyser.reversion.shaded.classtransform.annotations.CSlice;
import oxy.geyser.reversion.shaded.classtransform.annotations.CTarget;
import oxy.geyser.reversion.shaded.classtransform.mappings.AMapper;
import oxy.geyser.reversion.shaded.classtransform.mappings.annotation.RemapType;
import oxy.geyser.reversion.shaded.classtransform.targets.IInjectionTarget;
import oxy.geyser.reversion.shaded.classtransform.utils.ASMUtils;
import oxy.geyser.reversion.shaded.classtransform.utils.MemberDeclaration;
import oxy.geyser.reversion.shaded.classtransform.utils.Types;

@ParametersAreNonnullByDefault
public class NewTarget
implements IInjectionTarget {
    @Override
    public List<AbstractInsnNode> getTargets(Map<String, IInjectionTarget> injectionTargets, MethodNode method, CTarget target, @Nullable CSlice slice) {
        ArrayList<AbstractInsnNode> targets = new ArrayList<AbstractInsnNode>();
        int i = 0;
        for (AbstractInsnNode instruction : this.getSlice(injectionTargets, method, slice)) {
            if (instruction.getOpcode() != 183) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)instruction;
            if (!this.isTarget(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc, target.target())) continue;
            if (target.ordinal() == -1 || target.ordinal() == i) {
                targets.add(instruction);
            }
            ++i;
        }
        return targets;
    }

    @Override
    @Nullable
    public RemapType dynamicRemap(AMapper mapper, Class<?> annotation, Map<String, Object> values, Method remappedMethod, TransformerManager transformerManager, ClassNode target, ClassNode transformer) {
        String targetString = (String)values.get("target");
        if (targetString == null) {
            return null;
        }
        MemberDeclaration memberDeclaration = ASMUtils.splitMemberDeclaration(targetString);
        if (memberDeclaration != null) {
            return RemapType.MEMBER;
        }
        if (targetString.startsWith("(")) {
            return RemapType.DESCRIPTOR;
        }
        if (targetString.startsWith("L") && targetString.endsWith(";")) {
            targetString = targetString.substring(1, targetString.length() - 1);
            values.put("target", targetString);
        }
        return RemapType.CLASS;
    }

    private boolean isTarget(String owner, String name, String desc, String target) {
        if (!name.equals("<init>")) {
            return false;
        }
        MemberDeclaration declaration = ASMUtils.splitMemberDeclaration(target);
        if (declaration != null) {
            return declaration.is(owner, name, desc);
        }
        if (target.startsWith("(")) {
            if (desc.equals(target)) {
                return true;
            }
            Type expectedOwner = Types.returnType(target);
            Object[] expectedArgs = Types.argumentTypes(target);
            Object[] actualArgs = Types.argumentTypes(desc);
            return owner.equals(expectedOwner.getInternalName()) && Arrays.equals(expectedArgs, actualArgs);
        }
        if (target.startsWith("L") && target.endsWith(";")) {
            target = target.substring(1, target.length() - 1);
        }
        return owner.equals(ASMUtils.slash(target));
    }
}

