/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.utils.loader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.classtransform.TransformerManager;
import oxy.geyser.reversion.shaded.classtransform.utils.ASMUtils;
import oxy.geyser.reversion.shaded.classtransform.utils.IOSupplier;
import oxy.geyser.reversion.shaded.classtransform.utils.loader.BytesURLStreamHandler;
import oxy.geyser.reversion.shaded.classtransform.utils.loader.EnumLoaderPriority;
import oxy.geyser.reversion.shaded.classtransform.utils.loader.URLEnumeration;
import oxy.geyser.reversion.shaded.classtransform.utils.tree.IClassProvider;

@ParametersAreNonnullByDefault
public class InjectionClassLoader
extends URLClassLoader {
    private final TransformerManager transformerManager;
    private final ClassLoader parent;
    private final Set<String> protectedPackages = new HashSet<String>();
    private final Set<String> protectionExceptions = new HashSet<String>();
    private final Map<String, byte[]> runtimeResources = new HashMap<String, byte[]>();
    private EnumLoaderPriority priority = EnumLoaderPriority.CUSTOM_FIRST;

    public InjectionClassLoader(TransformerManager transformerManager, URL ... urls) {
        this(transformerManager, InjectionClassLoader.class.getClassLoader(), urls);
    }

    public InjectionClassLoader(TransformerManager transformerManager, ClassLoader parent, URL ... urls) {
        super(urls, (ClassLoader)null);
        this.transformerManager = transformerManager;
        this.parent = parent;
        this.protectedPackages.add("java.");
        this.protectedPackages.add("javax.");
        this.protectedPackages.add("sun.");
        this.protectedPackages.add("com.sun.");
        this.protectedPackages.add("jdk.");
        this.protectedPackages.add("oxy.geyser.reversion.shaded.classtransform.");
        this.protectedPackages.add("oxy.geyser.reversion.shaded.asm.");
        this.protectionExceptions.add("com.sun.jna.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(name);
            if (this.priority.equals((Object)EnumLoaderPriority.PARENT_FIRST)) {
                if (loadedClass == null) {
                    try {
                        loadedClass = this.parent.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (loadedClass == null) {
                        loadedClass = this.findClass(name);
                    }
                }
            } else if (loadedClass == null) {
                block14: {
                    try {
                        loadedClass = this.findClass(name);
                    }
                    catch (ClassNotFoundException t) {
                        if (this.parent != null) break block14;
                        throw t;
                    }
                }
                if (loadedClass == null) {
                    loadedClass = this.parent.loadClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.isProtected(name)) {
            if (this.priority.equals((Object)EnumLoaderPriority.PARENT_FIRST)) {
                return this.parent.loadClass(name);
            }
            throw new ClassNotFoundException(name);
        }
        try {
            URLConnection connection = this.getClassConnection(name);
            URL url = connection == null ? null : connection.getURL();
            byte[] classBytes = this.getClassBytes(name);
            CodeSigner[] codeSigner = null;
            String packageName = name.contains(".") ? name.substring(0, name.lastIndexOf(46)) : "";
            if (connection instanceof JarURLConnection) {
                JarURLConnection jarConnection = (JarURLConnection)connection;
                JarFile jarFile = jarConnection.getJarFile();
                url = jarConnection.getJarFileURL();
                if (jarFile != null && jarFile.getManifest() != null) {
                    Package pkg;
                    Manifest manifest = jarFile.getManifest();
                    JarEntry entry = jarFile.getJarEntry(ASMUtils.slash(name) + ".class");
                    if (entry != null) {
                        codeSigner = entry.getCodeSigners();
                    }
                    if ((pkg = this.getPackage(packageName)) == null) {
                        this.definePackage(packageName, manifest, jarConnection.getJarFileURL());
                    } else {
                        if (pkg.isSealed() && !pkg.isSealed(jarConnection.getJarFileURL())) {
                            throw new SecurityException("sealing violation: package " + packageName + " is sealed");
                        }
                        if (this.isSealed(packageName, manifest)) {
                            throw new SecurityException("sealing violation: can't seal package " + packageName + ": already loaded");
                        }
                    }
                }
            } else {
                Package pkg = this.getPackage(packageName);
                if (pkg == null) {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                } else if (pkg.isSealed()) {
                    throw new SecurityException("sealing violation: package " + packageName + " is sealed");
                }
            }
            byte[] transformedClassBytes = this.transformerManager.transform(name, classBytes);
            if (transformedClassBytes != null) {
                classBytes = transformedClassBytes;
            }
            CodeSource codeSource = null;
            if (connection != null) {
                codeSource = new CodeSource(url, codeSigner);
            }
            return this.defineClass(name, classBytes, 0, classBytes.length, codeSource);
        }
        catch (ClassFormatError | ClassNotFoundException | IndexOutOfBoundsException | SecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(name, t);
        }
    }

    private URLConnection getClassConnection(String className) throws IOException {
        URL url = this.findResource(ASMUtils.slash(className) + ".class");
        if (url != null) {
            if ("jar".equalsIgnoreCase(url.getProtocol()) && url.getRef() == null) {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + "#runtime");
            }
            return url.openConnection();
        }
        return null;
    }

    private byte[] getClassBytes(String name) throws ClassNotFoundException, IOException {
        int len;
        InputStream classStream = this.getResourceAsStream(ASMUtils.slash(name) + ".class");
        if (classStream == null) {
            throw new ClassNotFoundException(name);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = classStream.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        classStream.close();
        return baos.toByteArray();
    }

    private boolean isSealed(String path, Manifest manifest) {
        Attributes attributes = manifest.getAttributes(path);
        String sealed = null;
        if (attributes != null) {
            sealed = attributes.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attributes = manifest.getMainAttributes()) != null) {
            sealed = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    @Override
    @Nullable
    public URL getResource(String name) {
        IOSupplier<URL> parentSupplier = () -> this.parent.getResource(name);
        IOSupplier<URL> runtimeSupplier = () -> this.runtimeResources.containsKey(name) ? BytesURLStreamHandler.createURL(name, this.runtimeResources.get(name)) : null;
        IOSupplier<URL> superSupplier = () -> super.getResource(name);
        if (name.endsWith(".class")) {
            return this.getFirst(Objects::nonNull, runtimeSupplier, superSupplier);
        }
        if (this.priority.equals((Object)EnumLoaderPriority.PARENT_FIRST)) {
            return this.getFirst(Objects::nonNull, parentSupplier, runtimeSupplier, superSupplier);
        }
        return this.getFirst(Objects::nonNull, runtimeSupplier, superSupplier, parentSupplier);
    }

    @Override
    @Nullable
    public URL findResource(String name) {
        IOSupplier<URL> parentSupplier = () -> this.parent.getResource(name);
        IOSupplier<URL> runtimeSupplier = () -> this.runtimeResources.containsKey(name) ? BytesURLStreamHandler.createURL(name, this.runtimeResources.get(name)) : null;
        IOSupplier<URL> superSupplier = () -> super.findResource(name);
        if (name.endsWith(".class")) {
            return this.getFirst(Objects::nonNull, runtimeSupplier, superSupplier);
        }
        if (this.priority.equals((Object)EnumLoaderPriority.PARENT_FIRST)) {
            return this.getFirst(Objects::nonNull, parentSupplier, runtimeSupplier, superSupplier);
        }
        return this.getFirst(Objects::nonNull, runtimeSupplier, superSupplier, parentSupplier);
    }

    @Override
    @Nonnull
    public Enumeration<URL> findResources(String name) {
        IOSupplier<Enumeration> parentSupplier = () -> this.parent.getResources(name);
        IOSupplier<Enumeration> runtimeSupplier = () -> {
            if (this.runtimeResources.containsKey(name)) {
                return new URLEnumeration(BytesURLStreamHandler.createURL(name, this.runtimeResources.get(name)));
            }
            return Collections.emptyEnumeration();
        };
        IOSupplier<Enumeration> superSupplier = () -> super.findResources(name);
        if (name.endsWith(".class")) {
            return this.getFirst(Enumeration::hasMoreElements, runtimeSupplier, superSupplier);
        }
        if (this.priority.equals((Object)EnumLoaderPriority.PARENT_FIRST)) {
            return this.getFirst(Enumeration::hasMoreElements, parentSupplier, runtimeSupplier, superSupplier);
        }
        return this.getFirst(Enumeration::hasMoreElements, runtimeSupplier, superSupplier, parentSupplier);
    }

    @SafeVarargs
    private final <T> T getFirst(Predicate<T> predicate, IOSupplier<T> ... suppliers) {
        T value = null;
        for (IOSupplier<T> supplier : suppliers) {
            value = supplier.get();
            if (!predicate.test(value)) continue;
            return value;
        }
        return value;
    }

    public boolean isProtected(String className) {
        for (String protectedPackage : this.protectedPackages) {
            if (!className.startsWith(protectedPackage)) continue;
            for (String protectionException : this.protectionExceptions) {
                if (!className.startsWith(protectionException)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void addProtectedPackage(String protectedPackage) {
        this.protectedPackages.add(protectedPackage);
    }

    public void addProtectionException(String protectionException) {
        this.protectionExceptions.add(protectionException);
    }

    public TransformerManager getTransformerManager() {
        return this.transformerManager;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public void addRuntimeResource(String path, byte[] data) {
        this.runtimeResources.put(path, data);
    }

    public void copyResource(ClassLoader classLoader, String path) {
        try (InputStream is = classLoader.getResourceAsStream(path);){
            int len;
            if (is == null) {
                throw new IllegalArgumentException("Resource not found: " + path);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            this.addRuntimeResource(path, baos.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Resource not found: " + path);
        }
    }

    public void copyClass(IClassProvider classProvider, String className) {
        byte[] classBytes = classProvider.getClass(className);
        this.addRuntimeResource(ASMUtils.slash(className) + ".class", classBytes);
    }

    public void setPriority(EnumLoaderPriority priority) {
        if (priority.equals((Object)EnumLoaderPriority.PARENT_FIRST) && this.parent == null) {
            throw new IllegalArgumentException("Can't set the priority to PARENT_FIRST if no parent class loader is set");
        }
        this.priority = priority;
    }

    public void executeMain(String className, String methodName, String ... args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Thread.currentThread().setContextClassLoader(this);
        Class<?> mainClass = this.loadClass(className);
        Method method = mainClass.getMethod(methodName, String[].class);
        method.setAccessible(true);
        method.invoke(null, new Object[]{args});
    }
}

