/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.raphimc.minecraftauth.bedrock.BedrockAuthManager;
import net.raphimc.minecraftauth.msa.model.MsaDeviceCode;
import net.raphimc.minecraftauth.msa.service.impl.DeviceCodeMsaAuthService;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.PendingMicrosoftAuthentication;

public class PendingBedrockAuthentication {
    private final LoadingCache<String, AuthenticationTask> authentications = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AuthenticationTask>(){

        public AuthenticationTask load(@NonNull String userKey) {
            return new AuthenticationTask(userKey, GeyserImpl.getInstance().getConfig().getPendingAuthenticationTimeout());
        }
    });

    public AuthenticationTask getOrCreateTask(@NonNull String userKey) {
        return (AuthenticationTask)this.authentications.get((Object)userKey);
    }

    public class AuthenticationTask {
        private static final Executor DELAYED_BY_ONE_SECOND = CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS);
        private final int timeoutSec;
        private CompletableFuture<BedrockAuthManager> authentication;
        private final String userKey;

        public AuthenticationTask(String userKey, int timeoutSec) {
            this.userKey = userKey;
            this.timeoutSec = timeoutSec;
        }

        public void cleanup() {
            GeyserLogger logger = GeyserImpl.getInstance().getLogger();
            if (logger.isDebug()) {
                logger.debug("Cleaning up authentication task for " + this.userKey);
            }
            PendingBedrockAuthentication.this.authentications.invalidate((Object)this.userKey);
        }

        public void resetRunningFlow() {
            if (this.authentication == null) {
                return;
            }
            this.authentication.cancel(true);
        }

        public CompletableFuture<BedrockAuthManager> performLoginAttempt(Consumer<MsaDeviceCode> deviceCodeConsumer) {
            this.authentication = CompletableFuture.supplyAsync(() -> {
                try {
                    BedrockAuthManager auth = BedrockAuthManager.create((HttpClient)PendingMicrosoftAuthentication.AUTH_CLIENT, (String)GameProtocol.DEFAULT_BEDROCK_VERSION).login(DeviceCodeMsaAuthService::new, (Object)deviceCodeConsumer);
                    auth.getMinecraftCertificateChain().refresh();
                    auth.getMinecraftMultiplayerToken().refresh();
                    return auth;
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            }, DELAYED_BY_ONE_SECOND).whenComplete((r, ex) -> CompletableFuture.delayedExecutor(this.timeoutSec, TimeUnit.SECONDS).execute(this::cleanup));
            return this.authentication;
        }

        @Generated
        public CompletableFuture<BedrockAuthManager> getAuthentication() {
            return this.authentication;
        }
    }
}

