/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.converter.bitarray;

import com.github.blackjack200.ouranos.converter.bitarray.BitArray;
import com.github.blackjack200.ouranos.converter.bitarray.BitArrayVersion;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import org.cloudburstmc.math.GenericMath;

public record PaddedBitArray(BitArrayVersion version, int size, int[] words) implements BitArray
{
    public PaddedBitArray(BitArrayVersion version, int size, int[] words) {
        this.size = size;
        this.version = version;
        this.words = words;
        int expectedWordsLength = GenericMath.ceil((float)((float)size / (float)version.entriesPerWord));
        if (words.length != expectedWordsLength) {
            throw new IllegalArgumentException("Invalid length given for storage, got: " + words.length + " but expected: " + expectedWordsLength);
        }
    }

    @Override
    public void set(int index, int value) {
        Preconditions.checkElementIndex(index, this.size);
        if (value < 0 || value > this.version.maxEntryIndex) {
            throw new IllegalArgumentException(String.format("Max value: %s. Received value %s", this.version.maxEntryIndex, value));
        }
        int arrayIndex = index / this.version.entriesPerWord;
        int offset = index % this.version.entriesPerWord * this.version.bits;
        this.words[arrayIndex] = this.words[arrayIndex] & ~(this.version.maxEntryIndex << offset) | (value & this.version.maxEntryIndex) << offset;
    }

    @Override
    public int get(int index) {
        Preconditions.checkElementIndex(index, this.size);
        int arrayIndex = index / this.version.entriesPerWord;
        int offset = index % this.version.entriesPerWord * this.version.bits;
        return this.words[arrayIndex] >>> offset & this.version.maxEntryIndex;
    }

    @Override
    public BitArray copy() {
        return new PaddedBitArray(this.version, this.size, Arrays.copyOf(this.words, this.words.length));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PaddedBitArray)) {
            return false;
        }
        PaddedBitArray that = (PaddedBitArray)o;
        return this.size == that.size && this.version == that.version && Arrays.equals(this.words, that.words);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.size, Arrays.hashCode(this.words)});
    }
}

