/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.data.bedrock;

import com.github.blackjack200.ouranos.converter.ItemTypeDictionary;
import com.github.blackjack200.ouranos.data.bedrock.item.downgrade.ItemIdMetaDowngrader;
import com.github.blackjack200.ouranos.data.bedrock.item.upgrade.ItemDataUpgrader;
import com.github.blackjack200.ouranos.data.bedrock.item.upgrade.ItemIdMetaUpgradeSchemaUtils;
import com.github.blackjack200.ouranos.data.bedrock.item.upgrade.ItemIdMetaUpgrader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class GlobalItemDataHandlers {
    private static ItemDataUpgrader itemDataUpgrader = null;
    private static Map<Integer, ItemIdMetaDowngrader> downgrader = new HashMap<Integer, ItemIdMetaDowngrader>();
    public static Map<Integer, Integer> SCHEMA_ID = new ConcurrentHashMap<Integer, Integer>();

    public static ItemDataUpgrader getUpgrader() {
        if (itemDataUpgrader == null) {
            itemDataUpgrader = new ItemDataUpgrader(new ItemIdMetaUpgrader(ItemIdMetaUpgradeSchemaUtils.loadSchemas("schema/id_meta_upgrade_schema", 0x40000000).values()));
        }
        return itemDataUpgrader;
    }

    public static int getSchemaId(int protocolId) {
        Integer id = SCHEMA_ID.getOrDefault(protocolId, null);
        if (id == null) {
            throw new RuntimeException("schemaid for protocol " + protocolId + " not found");
        }
        return id;
    }

    public static ItemIdMetaDowngrader getItemIdMetaDowngrader(int protocolId) {
        if (!downgrader.containsKey(protocolId)) {
            downgrader.put(protocolId, new ItemIdMetaDowngrader(ItemTypeDictionary.getInstance(protocolId), GlobalItemDataHandlers.getSchemaId(protocolId)));
        }
        return downgrader.get(protocolId);
    }
}

