/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.data.bedrock.item.upgrade;

import com.github.blackjack200.ouranos.data.bedrock.item.upgrade.ItemIdMetaUpgradeSchema;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public final class ItemIdMetaUpgrader {
    private final Map<Integer, ItemIdMetaUpgradeSchema> idMetaUpgradeSchemas = new TreeMap<Integer, ItemIdMetaUpgradeSchema>();

    public ItemIdMetaUpgrader(Collection<ItemIdMetaUpgradeSchema> idMetaUpgradeSchemas) {
        for (ItemIdMetaUpgradeSchema schema : idMetaUpgradeSchemas) {
            this.addSchema(schema);
        }
    }

    public void addSchema(ItemIdMetaUpgradeSchema schema) {
        if (this.idMetaUpgradeSchemas.containsKey(schema.schemaId())) {
            throw new IllegalArgumentException("Already have a schema with priority " + schema.schemaId());
        }
        this.idMetaUpgradeSchemas.put(schema.schemaId(), schema);
    }

    public Map<Integer, ItemIdMetaUpgradeSchema> getSchemas() {
        return this.idMetaUpgradeSchemas;
    }

    public Object[] upgrade(String id, int meta) {
        String newId = id;
        int newMeta = meta;
        for (ItemIdMetaUpgradeSchema schema : this.idMetaUpgradeSchemas.values()) {
            String remappedMetaId = schema.remapMeta(newId, newMeta);
            if (remappedMetaId != null) {
                newId = remappedMetaId;
                newMeta = 0;
                continue;
            }
            String renamedId = schema.renameId(newId);
            if (renamedId == null) continue;
            newId = renamedId;
        }
        return new Object[]{newId, newMeta};
    }
}

