/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.session;

import com.github.blackjack200.ouranos.ProtocolInfo;
import com.github.blackjack200.ouranos.base.ProtocolToProtocol;
import com.github.blackjack200.ouranos.base.WrappedBedrockPacket;
import com.github.blackjack200.ouranos.session.storage.OuranosStorage;
import com.github.blackjack200.ouranos.shaded.lombok.Generated;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.AuthoritativeMovementMode;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.BedrockPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.StartGamePacket;
import com.github.blackjack200.ouranos.translators.GlobalItemTranslator;
import com.github.blackjack200.ouranos.translators.GlobalProtocolTranslator;
import com.github.blackjack200.ouranos.translators.GlobalWorldTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OuranosSession {
    private static final List<ProtocolToProtocol> GLOBAL_TRANSLATORS = new ArrayList<ProtocolToProtocol>();
    private long uniqueId;
    private long runtimeId;
    private final int protocolId;
    private final int targetVersion;
    private boolean serverAuthoritativeInventories;
    private boolean serverAuthoritativeBlockBreaking;
    private AuthoritativeMovementMode authoritativeMovementMode;
    private final Map<Class<?>, OuranosStorage> storages = new HashMap();
    private final List<ProtocolToProtocol> translators = new ArrayList<ProtocolToProtocol>();
    private final List<ProtocolToProtocol> reversedTranslators;

    public void put(OuranosStorage storage) {
        this.storages.put(storage.getClass(), storage);
    }

    public final <T extends OuranosStorage> T get(Class<T> klass) {
        return (T)this.storages.get(klass);
    }

    public OuranosSession(int protocolId, int targetVersion) {
        this.protocolId = protocolId;
        this.targetVersion = targetVersion;
        this.translators.addAll(ProtocolInfo.getTranslators(targetVersion, protocolId));
        this.translators.forEach(translator -> translator.init(this));
        GLOBAL_TRANSLATORS.forEach(translator -> translator.init(this));
        this.reversedTranslators = new ArrayList<ProtocolToProtocol>();
        this.reversedTranslators.addAll(this.translators);
        Collections.reverse(this.reversedTranslators);
    }

    public abstract void sendUpstreamPacket(BedrockPacket var1);

    public abstract void sendDownstreamPacket(BedrockPacket var1);

    public final BedrockPacket translateClientbound(BedrockPacket packet) {
        if (packet instanceof StartGamePacket) {
            StartGamePacket startGamePacket = (StartGamePacket)packet;
            this.uniqueId = startGamePacket.getUniqueEntityId();
            this.runtimeId = startGamePacket.getRuntimeEntityId();
            this.serverAuthoritativeInventories = startGamePacket.isInventoriesServerAuthoritative();
            this.authoritativeMovementMode = startGamePacket.getAuthoritativeMovementMode();
            this.serverAuthoritativeBlockBreaking = startGamePacket.isServerAuthoritativeBlockBreaking();
        }
        WrappedBedrockPacket wrapped = new WrappedBedrockPacket(this, this.getTargetVersion(), this.getProtocolId(), packet, false);
        for (ProtocolToProtocol translator : GLOBAL_TRANSLATORS) {
            translator.passthroughClientbound(wrapped);
        }
        for (ProtocolToProtocol translator : this.translators) {
            translator.passthroughClientbound(wrapped);
        }
        return wrapped.isCancelled() ? null : wrapped.getPacket();
    }

    public final BedrockPacket translateServerbound(BedrockPacket packet) {
        WrappedBedrockPacket wrapped = new WrappedBedrockPacket(this, this.getProtocolId(), this.getTargetVersion(), packet, false);
        for (ProtocolToProtocol translator : GLOBAL_TRANSLATORS) {
            translator.passthroughServerbound(wrapped);
        }
        for (ProtocolToProtocol translator : this.reversedTranslators) {
            translator.passthroughServerbound(wrapped);
        }
        return wrapped.isCancelled() ? null : wrapped.getPacket();
    }

    @Generated
    public long getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public long getRuntimeId() {
        return this.runtimeId;
    }

    @Generated
    public void setUniqueId(long uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public void setRuntimeId(long runtimeId) {
        this.runtimeId = runtimeId;
    }

    @Generated
    public int getProtocolId() {
        return this.protocolId;
    }

    @Generated
    public int getTargetVersion() {
        return this.targetVersion;
    }

    @Generated
    public boolean isServerAuthoritativeInventories() {
        return this.serverAuthoritativeInventories;
    }

    @Generated
    public boolean isServerAuthoritativeBlockBreaking() {
        return this.serverAuthoritativeBlockBreaking;
    }

    @Generated
    public AuthoritativeMovementMode getAuthoritativeMovementMode() {
        return this.authoritativeMovementMode;
    }

    static {
        GLOBAL_TRANSLATORS.add(new GlobalProtocolTranslator());
        GLOBAL_TRANSLATORS.add(new GlobalWorldTranslator());
        GLOBAL_TRANSLATORS.add(new GlobalItemTranslator());
    }
}

