/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v554.serializer;

import com.github.blackjack200.ouranos.shaded.fastutil.objects.ObjectArrayList;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v332.serializer.TextSerializer_v332;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.TextPacket;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.TextConverter;
import io.netty.buffer.ByteBuf;

public class TextSerializer_v554
extends TextSerializer_v332 {
    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, TextPacket packet) {
        TextPacket.Type type = packet.getType();
        buffer.writeByte(type.ordinal());
        TextConverter converter = helper.getTextConverter();
        CharSequence message = packet.getMessage(CharSequence.class);
        Boolean needsTranslation = converter.needsTranslation(message);
        buffer.writeBoolean(needsTranslation != null ? needsTranslation.booleanValue() : packet.isNeedsTranslation());
        switch (type) {
            case CHAT: 
            case WHISPER: 
            case ANNOUNCEMENT: {
                helper.writeString(buffer, packet.getSourceName());
            }
            case RAW: 
            case TIP: 
            case SYSTEM: {
                helper.writeString(buffer, converter.serialize(message));
                break;
            }
            case JSON: 
            case WHISPER_JSON: 
            case ANNOUNCEMENT_JSON: {
                helper.writeString(buffer, converter.serializeJson(message));
                break;
            }
            case TRANSLATION: 
            case POPUP: 
            case JUKEBOX_POPUP: {
                String text = converter.serializeWithArguments(message, packet.getParameters());
                helper.writeString(buffer, text);
                helper.writeArray(buffer, packet.getParameters(), helper::writeString);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported TextType " + (Object)((Object)type));
            }
        }
        helper.writeString(buffer, packet.getXuid());
        helper.writeString(buffer, packet.getPlatformChatId());
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, TextPacket packet) {
        TextPacket.Type type = TextPacket.Type.values()[buffer.readUnsignedByte()];
        packet.setType(type);
        TextConverter converter = helper.getTextConverter();
        boolean needsTranslation = buffer.readBoolean();
        switch (type) {
            case CHAT: 
            case WHISPER: 
            case ANNOUNCEMENT: {
                packet.setSourceName(helper.readString(buffer));
            }
            case RAW: 
            case TIP: 
            case SYSTEM: {
                String text = helper.readString(buffer);
                packet.setMessage(converter.deserialize(text, needsTranslation));
                break;
            }
            case JSON: 
            case WHISPER_JSON: 
            case ANNOUNCEMENT_JSON: {
                String text2 = helper.readString(buffer);
                packet.setMessage(converter.deserializeJson(text2, needsTranslation));
                break;
            }
            case TRANSLATION: 
            case POPUP: 
            case JUKEBOX_POPUP: {
                String text3 = helper.readString(buffer);
                ObjectArrayList<String> parameters = new ObjectArrayList<String>();
                helper.readArray(buffer, parameters, helper::readString);
                CharSequence message2 = converter.deserializeWithArguments(text3, parameters, needsTranslation);
                packet.setMessage(message2);
                packet.setParameters(parameters);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported TextType " + (Object)((Object)type));
            }
        }
        packet.setXuid(helper.readString(buffer));
        packet.setPlatformChatId(helper.readString(buffer));
    }
}

