/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v748.serializer;

import com.github.blackjack200.ouranos.shaded.fastutil.objects.ObjectArrayList;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v685.serializer.CraftingDataSerializer_v685;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ItemData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.crafting.CraftingDataType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.crafting.RecipeUnlockingRequirement;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.crafting.recipe.ShapelessRecipeData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.VarInts;
import io.netty.buffer.ByteBuf;
import java.util.UUID;

public class CraftingDataSerializer_v748
extends CraftingDataSerializer_v685 {
    public static final CraftingDataSerializer_v748 INSTANCE = new CraftingDataSerializer_v748();

    @Override
    protected ShapelessRecipeData readShapelessRecipe(ByteBuf buffer, BedrockCodecHelper helper, CraftingDataType type) {
        String recipeId = helper.readString(buffer);
        ObjectArrayList<ItemDescriptorWithCount> inputs = new ObjectArrayList<ItemDescriptorWithCount>();
        helper.readArray(buffer, inputs, helper::readIngredient);
        ObjectArrayList<ItemData> outputs = new ObjectArrayList<ItemData>();
        helper.readArray(buffer, outputs, helper::readItemInstance);
        UUID uuid = helper.readUuid(buffer);
        String craftingTag = helper.readString(buffer);
        int priority = VarInts.readInt(buffer);
        RecipeUnlockingRequirement requirement = RecipeUnlockingRequirement.INVALID;
        if (type == CraftingDataType.SHAPELESS || type == CraftingDataType.SHULKER_BOX) {
            requirement = this.readRequirement(buffer, helper, type);
        }
        int networkId = VarInts.readUnsignedInt(buffer);
        return ShapelessRecipeData.of(type, recipeId, inputs, outputs, uuid, craftingTag, priority, networkId, requirement);
    }

    @Override
    protected void writeShapelessRecipe(ByteBuf buffer, BedrockCodecHelper helper, ShapelessRecipeData data) {
        helper.writeString(buffer, data.getId());
        helper.writeArray(buffer, data.getIngredients(), helper::writeIngredient);
        helper.writeArray(buffer, data.getResults(), helper::writeItemInstance);
        helper.writeUuid(buffer, data.getUuid());
        helper.writeString(buffer, data.getTag());
        VarInts.writeInt(buffer, data.getPriority());
        if (data.getType() == CraftingDataType.SHAPELESS || data.getType() == CraftingDataType.SHULKER_BOX) {
            this.writeRequirement(buffer, helper, data);
        }
        VarInts.writeUnsignedInt(buffer, data.getNetId());
    }

    protected CraftingDataSerializer_v748() {
    }
}

