/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v776;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.EntityDataTypeMap;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v766.BedrockCodecHelper_v766;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.Ability;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.AbilityLayer;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ContainerSlotType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.TextProcessingEventOrigin;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.TypeMap;
import io.netty.buffer.ByteBuf;

public class BedrockCodecHelper_v776
extends BedrockCodecHelper_v766 {
    public BedrockCodecHelper_v776(EntityDataTypeMap entityData, TypeMap<Class<?>> gameRulesTypes, TypeMap<ItemStackRequestActionType> stackRequestActionTypes, TypeMap<ContainerSlotType> containerSlotTypes, TypeMap<Ability> abilities, TypeMap<TextProcessingEventOrigin> textProcessingEventOrigins) {
        super(entityData, gameRulesTypes, stackRequestActionTypes, containerSlotTypes, abilities, textProcessingEventOrigins);
    }

    @Override
    protected void writeAbilityLayer(ByteBuf buffer, AbilityLayer abilityLayer) {
        buffer.writeShortLE(abilityLayer.getLayerType().ordinal());
        buffer.writeIntLE(this.getAbilitiesNumber(abilityLayer.getAbilitiesSet()));
        buffer.writeIntLE(this.getAbilitiesNumber(abilityLayer.getAbilityValues()));
        buffer.writeFloatLE(abilityLayer.getFlySpeed());
        buffer.writeFloatLE(abilityLayer.getVerticalFlySpeed());
        buffer.writeFloatLE(abilityLayer.getWalkSpeed());
    }

    @Override
    protected AbilityLayer readAbilityLayer(ByteBuf buffer) {
        AbilityLayer abilityLayer = new AbilityLayer();
        abilityLayer.setLayerType(AbilityLayer.Type.values()[buffer.readUnsignedShortLE()]);
        this.readAbilitiesFromNumber(buffer.readIntLE(), abilityLayer.getAbilitiesSet());
        this.readAbilitiesFromNumber(buffer.readIntLE(), abilityLayer.getAbilityValues());
        abilityLayer.setFlySpeed(buffer.readFloatLE());
        abilityLayer.setVerticalFlySpeed(buffer.readFloatLE());
        abilityLayer.setWalkSpeed(buffer.readFloatLE());
        return abilityLayer;
    }
}

