/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.command;

import com.github.blackjack200.ouranos.shaded.lombok.NonNull;
import java.util.Arrays;

public final class CommandOutputMessage {
    private final boolean internal;
    @NonNull
    private final String messageId;
    @NonNull
    private final String[] parameters;

    public CommandOutputMessage(boolean internal, @NonNull String messageId, @NonNull String[] parameters) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.internal = internal;
        this.messageId = messageId;
        this.parameters = parameters;
    }

    public boolean isInternal() {
        return this.internal;
    }

    @NonNull
    public String getMessageId() {
        return this.messageId;
    }

    @NonNull
    public String[] getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandOutputMessage)) {
            return false;
        }
        CommandOutputMessage other = (CommandOutputMessage)o;
        if (this.isInternal() != other.isInternal()) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        return Arrays.deepEquals(this.getParameters(), other.getParameters());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInternal() ? 79 : 97);
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getParameters());
        return result;
    }

    public String toString() {
        return "CommandOutputMessage(internal=" + this.isInternal() + ", messageId=" + this.getMessageId() + ", parameters=" + Arrays.deepToString(this.getParameters()) + ")";
    }
}

