/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.common.util.index;

import com.github.blackjack200.ouranos.shaded.fastutil.objects.ObjectArrayList;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.index.Indexable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class IndexedList<T>
implements Indexable<List<T>> {
    private final List<T> values;
    private final int[] indices;
    private List<T> cached;

    public IndexedList(List<T> values, int[] indices) {
        this.values = Objects.requireNonNull(values, "values cannot be null");
        this.indices = Objects.requireNonNull(indices, "indices cannot be null");
    }

    @Override
    public List<T> get() {
        if (this.cached != null) {
            return this.cached;
        }
        if (this.indices.length == 0) {
            return Collections.emptyList();
        }
        ObjectArrayList<T> indexedValues = new ObjectArrayList<T>(this.indices.length);
        for (int index : this.indices) {
            indexedValues.add(this.values.get(index));
        }
        this.cached = indexedValues;
        return this.cached;
    }
}

