/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.translators;

import com.github.blackjack200.ouranos.base.ProtocolToProtocol;
import com.github.blackjack200.ouranos.base.WrappedBedrockPacket;
import com.github.blackjack200.ouranos.converter.ItemTypeDictionary;
import com.github.blackjack200.ouranos.converter.TypeConverter;
import com.github.blackjack200.ouranos.data.ItemTypeInfo;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.FullContainerName;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.ConsumeAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.DestroyAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.DropAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.PlaceAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.SwapAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.TakeAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.transaction.InventoryActionData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.AddItemEntityPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.AddPlayerPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.BedrockPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.CraftingDataPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.CreativeContentPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.InventoryContentPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.InventorySlotPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.InventoryTransactionPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.ItemComponentPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.ItemStackRequestPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.MobArmorEquipmentPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.MobEquipmentPacket;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Optional;

public class GlobalItemTranslator
extends ProtocolToProtocol {
    @Override
    protected void registerProtocol() {
        this.registerServerbound(ItemStackRequestPacket.class, wrapped -> {
            ItemStackRequestPacket packet = (ItemStackRequestPacket)wrapped.getPacket();
            ArrayList<ItemStackRequest> newRequests = new ArrayList<ItemStackRequest>();
            for (ItemStackRequest request : packet.getRequests()) {
                ItemStackRequestAction[] actions;
                ArrayList<ItemStackRequestAction> newActions = new ArrayList<ItemStackRequestAction>();
                ItemStackRequestAction[] itemStackRequestActionArray = actions = request.getActions();
                int n = itemStackRequestActionArray.length;
                block9: for (int i = 0; i < n; ++i) {
                    ItemStackRequestAction action;
                    ItemStackRequestAction selector0$temp = action = itemStackRequestActionArray[i];
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TakeAction.class, ConsumeAction.class, DestroyAction.class, DropAction.class, PlaceAction.class, SwapAction.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            TakeAction a = (TakeAction)selector0$temp;
                            newActions.add(new TakeAction(a.getCount(), this.translateItemStackRequestSlotData(a.getSource()), this.translateItemStackRequestSlotData(a.getDestination())));
                            continue block9;
                        }
                        case 1: {
                            ConsumeAction a = (ConsumeAction)selector0$temp;
                            newActions.add(new ConsumeAction(a.getCount(), this.translateItemStackRequestSlotData(a.getSource())));
                            continue block9;
                        }
                        case 2: {
                            DestroyAction a = (DestroyAction)selector0$temp;
                            newActions.add(new DestroyAction(a.getCount(), this.translateItemStackRequestSlotData(a.getSource())));
                            continue block9;
                        }
                        case 3: {
                            DropAction a = (DropAction)selector0$temp;
                            newActions.add(new DropAction(a.getCount(), this.translateItemStackRequestSlotData(a.getSource()), a.isRandomly()));
                            continue block9;
                        }
                        case 4: {
                            PlaceAction a = (PlaceAction)selector0$temp;
                            PlaceAction newAct = new PlaceAction(a.getCount(), this.translateItemStackRequestSlotData(a.getSource()), this.translateItemStackRequestSlotData(a.getDestination()));
                            newActions.add(newAct);
                            continue block9;
                        }
                        case 5: {
                            SwapAction a = (SwapAction)selector0$temp;
                            newActions.add(new SwapAction(this.translateItemStackRequestSlotData(a.getSource()), this.translateItemStackRequestSlotData(a.getDestination())));
                            continue block9;
                        }
                        default: {
                            newActions.add(action);
                        }
                    }
                }
                newRequests.add(new ItemStackRequest(request.getRequestId(), newActions.toArray(new ItemStackRequestAction[0]), request.getFilterStrings()));
            }
            packet.getRequests().clear();
            packet.getRequests().addAll(newRequests);
        });
        this.registerClientbound(InventoryContentPacket.class, wrapped -> {
            InventoryContentPacket packet = (InventoryContentPacket)wrapped.getPacket();
            packet.getContents().replaceAll(itemData -> TypeConverter.translateItemData(wrapped.getInput(), wrapped.getOutput(), itemData));
        });
        this.registerClientbound(ItemComponentPacket.class, wrapped -> {
            ItemComponentPacket packet = (ItemComponentPacket)wrapped.getPacket();
            ItemTypeDictionary.InnerEntry itemDictionary = ItemTypeDictionary.getInstance(wrapped.getOutput());
            packet.getItems().removeIf(definition -> ItemTypeDictionary.getInstance(wrapped.getInput()).fromStringId(definition.getIdentifier()) != null);
            packet.getItems().removeIf(definition -> itemDictionary.fromStringId(definition.getIdentifier()) != null);
            packet.getItems().addAll(itemDictionary.getEntries().entrySet().stream().map(e -> ((ItemTypeInfo)e.getValue()).toDefinition((String)e.getKey())).toList());
        });
        this.registerClientbound(CraftingDataPacket.class, wrapped -> {
            CraftingDataPacket packet = (CraftingDataPacket)wrapped.getPacket();
            packet.getPotionMixData().clear();
            packet.getMaterialReducers().clear();
            packet.getCraftingData().clear();
            packet.getContainerMixData().clear();
            packet.setCleanRecipes(true);
        });
        this.registerClientbound(CreativeContentPacket.class, wrapped -> {
            CreativeContentPacket packet = (CreativeContentPacket)wrapped.getPacket();
            int input = wrapped.getInput();
            int output = wrapped.getOutput();
            packet.getContents().clear();
            packet.getGroups().clear();
        });
        this.registerClientbound(AddItemEntityPacket.class, wrapped -> {
            AddItemEntityPacket packet = (AddItemEntityPacket)wrapped.getPacket();
            packet.setItemInHand(TypeConverter.translateItemData(wrapped.getInput(), wrapped.getOutput(), packet.getItemInHand()));
        });
        this.registerClientbound(InventorySlotPacket.class, wrapped -> {
            InventorySlotPacket packet = (InventorySlotPacket)wrapped.getPacket();
            int input = wrapped.getInput();
            int output = wrapped.getOutput();
            packet.setItem(TypeConverter.translateItemData(input, output, packet.getItem()));
            packet.setStorageItem(TypeConverter.translateItemData(input, output, packet.getStorageItem()));
        });
        this.registerClientbound(AddPlayerPacket.class, wrapped -> {
            AddPlayerPacket packet = (AddPlayerPacket)wrapped.getPacket();
            packet.setHand(TypeConverter.translateItemData(wrapped.getInput(), wrapped.getOutput(), packet.getHand()));
        });
        this.registerClientbound(InventoryTransactionPacket.class, this::translateBothWay);
        this.registerClientbound(MobEquipmentPacket.class, this::translateBothWay);
        this.registerClientbound(MobArmorEquipmentPacket.class, this::translateBothWay);
        this.registerServerbound(InventoryTransactionPacket.class, this::translateBothWay);
        this.registerServerbound(MobEquipmentPacket.class, this::translateBothWay);
        this.registerServerbound(MobArmorEquipmentPacket.class, this::translateBothWay);
    }

    private void translateBothWay(WrappedBedrockPacket wrapped) {
        int input = wrapped.getInput();
        int output = wrapped.getOutput();
        BedrockPacket bedrockPacket = wrapped.getPacket();
        if (bedrockPacket instanceof InventoryTransactionPacket) {
            InventoryTransactionPacket packet = (InventoryTransactionPacket)bedrockPacket;
            for (int i = 0; i < packet.getActions().size(); ++i) {
                InventoryActionData action = packet.getActions().get(i);
                packet.getActions().set(i, new InventoryActionData(action.getSource(), action.getSlot(), TypeConverter.translateItemData(input, output, action.getFromItem()), TypeConverter.translateItemData(input, output, action.getToItem()), action.getStackNetworkId()));
            }
            if (packet.getBlockDefinition() != null) {
                packet.setBlockDefinition(TypeConverter.translateBlockDefinition(input, output, packet.getBlockDefinition()));
            }
            if (packet.getItemInHand() != null) {
                packet.setItemInHand(TypeConverter.translateItemData(input, output, packet.getItemInHand()));
            }
        } else if (bedrockPacket instanceof MobEquipmentPacket) {
            MobEquipmentPacket packet = (MobEquipmentPacket)bedrockPacket;
            packet.setItem(TypeConverter.translateItemData(input, output, packet.getItem()));
        } else if (bedrockPacket instanceof MobArmorEquipmentPacket) {
            MobArmorEquipmentPacket packet = (MobArmorEquipmentPacket)bedrockPacket;
            if (packet.getBody() != null) {
                packet.setBody(TypeConverter.translateItemData(input, output, packet.getBody()));
            }
            packet.setChestplate(TypeConverter.translateItemData(input, output, packet.getChestplate()));
            packet.setHelmet(TypeConverter.translateItemData(input, output, packet.getHelmet()));
            packet.setBoots(TypeConverter.translateItemData(input, output, packet.getBoots()));
            packet.setLeggings(TypeConverter.translateItemData(input, output, packet.getLeggings()));
        }
    }

    private ItemStackRequestSlotData translateItemStackRequestSlotData(ItemStackRequestSlotData dest) {
        return new ItemStackRequestSlotData(dest.getContainer(), dest.getSlot(), dest.getStackNetworkId(), Optional.ofNullable(dest.getContainerName()).orElse(new FullContainerName(dest.getContainer(), 0)));
    }
}

