/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.translators.new_to_old.v388to361;

import com.github.blackjack200.ouranos.base.ProtocolToProtocol;
import com.github.blackjack200.ouranos.converter.BlockStateDictionary;
import com.github.blackjack200.ouranos.data.LegacyBlockIdToStringIdMap;
import com.github.blackjack200.ouranos.data.bedrock.GlobalBlockDataHandlers;
import com.github.blackjack200.ouranos.data.bedrock.block.BlockIdMetaUpgrader;
import com.github.blackjack200.ouranos.session.OuranosSession;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.AuthoritativeMovementMode;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.PlayerActionType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.PlayerAuthInputData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.SoundEvent;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.LevelSoundEventPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.MovePlayerPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.PlayerActionPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.StartGamePacket;
import com.github.blackjack200.ouranos.translators.new_to_old.v388to361.storage.ClientAuthMovementStorage;
import java.util.Map;
import java.util.Objects;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;

public class Protocol388to361
extends ProtocolToProtocol {
    @Override
    public void init(OuranosSession session) {
        session.put(new ClientAuthMovementStorage(session));
    }

    @Override
    protected void registerProtocol() {
        this.registerServerbound(PlayerActionPacket.class, wrapped -> {
            if (wrapped.session().getAuthoritativeMovementMode() == AuthoritativeMovementMode.CLIENT) {
                return;
            }
            ClientAuthMovementStorage storage = wrapped.session().get(ClientAuthMovementStorage.class);
            PlayerActionPacket packet = (PlayerActionPacket)wrapped.getPacket();
            PlayerActionType actionType = packet.getAction();
            switch (actionType) {
                case START_SPRINT: {
                    storage.getInputData().add(PlayerAuthInputData.START_SPRINTING);
                    break;
                }
                case STOP_SPRINT: {
                    storage.getInputData().add(PlayerAuthInputData.STOP_SPRINTING);
                    break;
                }
                case START_SNEAK: {
                    storage.getInputData().add(PlayerAuthInputData.START_SNEAKING);
                    break;
                }
                case STOP_SNEAK: {
                    storage.getInputData().add(PlayerAuthInputData.STOP_SNEAKING);
                    break;
                }
                case START_SWIMMING: {
                    storage.getInputData().add(PlayerAuthInputData.START_SWIMMING);
                    break;
                }
                case STOP_SWIMMING: {
                    storage.getInputData().add(PlayerAuthInputData.STOP_SWIMMING);
                    break;
                }
                case START_GLIDE: {
                    storage.getInputData().add(PlayerAuthInputData.START_GLIDING);
                    break;
                }
                case STOP_GLIDE: {
                    storage.getInputData().add(PlayerAuthInputData.STOP_GLIDING);
                    break;
                }
                case START_CRAWLING: {
                    storage.getInputData().add(PlayerAuthInputData.START_CRAWLING);
                    break;
                }
                case STOP_CRAWLING: {
                    storage.getInputData().add(PlayerAuthInputData.STOP_CRAWLING);
                    break;
                }
                case START_FLYING: {
                    storage.getInputData().add(PlayerAuthInputData.START_FLYING);
                    break;
                }
                case STOP_FLYING: {
                    storage.getInputData().add(PlayerAuthInputData.STOP_FLYING);
                    break;
                }
                case JUMP: {
                    storage.getInputData().add(PlayerAuthInputData.START_JUMPING);
                }
            }
        });
        this.registerServerbound(MovePlayerPacket.class, wrapped -> {
            if (wrapped.session().getAuthoritativeMovementMode() == AuthoritativeMovementMode.CLIENT) {
                return;
            }
            ClientAuthMovementStorage storage = wrapped.session().get(ClientAuthMovementStorage.class);
            MovePlayerPacket packet = (MovePlayerPacket)wrapped.getPacket();
            storage.setPosition(packet.getPosition());
            storage.setRotation(packet.getRotation());
            wrapped.setPacket(storage.toAuthInput());
        });
        this.registerServerbound(LevelSoundEventPacket.class, wrapped -> {
            if (wrapped.session().getAuthoritativeMovementMode() == AuthoritativeMovementMode.CLIENT) {
                return;
            }
            LevelSoundEventPacket packet = (LevelSoundEventPacket)wrapped.getPacket();
            if (packet.getSound() == SoundEvent.ATTACK_NODAMAGE) {
                ClientAuthMovementStorage storage = wrapped.session().get(ClientAuthMovementStorage.class);
                storage.getInputData().add(PlayerAuthInputData.MISSED_SWING);
            }
        });
        this.registerServerbound(StartGamePacket.class, wrapped -> {
            StartGamePacket packet = (StartGamePacket)wrapped.getPacket();
            packet.setBlockPalette((NbtList<NbtMap>)new NbtList(NbtType.COMPOUND, BlockStateDictionary.getInstance(wrapped.getOutput()).getKnownStates().stream().map(e -> {
                BlockIdMetaUpgrader.Block blk = GlobalBlockDataHandlers.getUpgrader().fromLatestStateHash(e.latestStateHash());
                short legacyId = (short)(Objects.requireNonNullElse(LegacyBlockIdToStringIdMap.getInstance().fromString(wrapped.getOutput(), e.name()), 255) & 0xFFFFFFF);
                return NbtMap.builder().putCompound("block", NbtMap.fromMap(Map.of("name", blk.id(), "meta", (short)blk.meta(), "id", legacyId))).build();
            }).toList()));
        });
    }
}

