/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.utils;

import com.github.blackjack200.ouranos.converter.ItemTypeDictionary;
import com.github.blackjack200.ouranos.data.ItemTypeInfo;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.definitions.ItemDefinition;
import com.github.blackjack200.ouranos.shaded.protocol.common.DefinitionRegistry;
import com.github.blackjack200.ouranos.utils.SimpleVersionedItemDefinition;

public class ItemTypeDictionaryRegistry
implements DefinitionRegistry<ItemDefinition> {
    private final DefinitionRegistry<ItemDefinition> registry;
    private final int protocol;

    public ItemTypeDictionaryRegistry(DefinitionRegistry<ItemDefinition> registry, int protocol) {
        this.protocol = protocol;
        this.registry = registry;
    }

    @Override
    public ItemDefinition getDefinition(int runtimeId) {
        ItemTypeDictionary.InnerEntry entry = ItemTypeDictionary.getInstance(this.protocol);
        String itemId = entry.fromIntId(runtimeId);
        ItemTypeInfo itemInfo = entry.getEntries().get(itemId);
        if (itemInfo == null) {
            return this.registry.getDefinition(runtimeId);
        }
        return new SimpleVersionedItemDefinition(itemId, itemInfo.runtime_id(), itemInfo.getVersion(), itemInfo.component_based(), itemInfo.getComponentNbt());
    }

    @Override
    public boolean isRegistered(ItemDefinition definition) {
        return this.registry.isRegistered(definition) || ItemTypeDictionary.getInstance(this.protocol).fromStringId(definition.getIdentifier()) != null;
    }
}

