/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.transformer.impl;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.asm.Type;
import oxy.geyser.reversion.shaded.asm.tree.AbstractInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.ClassNode;
import oxy.geyser.reversion.shaded.asm.tree.InsnList;
import oxy.geyser.reversion.shaded.asm.tree.InsnNode;
import oxy.geyser.reversion.shaded.asm.tree.JumpInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.LabelNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodNode;
import oxy.geyser.reversion.shaded.asm.tree.TypeInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.VarInsnNode;
import oxy.geyser.reversion.shaded.classtransform.InjectionCallback;
import oxy.geyser.reversion.shaded.classtransform.TransformerManager;
import oxy.geyser.reversion.shaded.classtransform.annotations.CTarget;
import oxy.geyser.reversion.shaded.classtransform.annotations.injection.CInject;
import oxy.geyser.reversion.shaded.classtransform.exceptions.InvalidTargetException;
import oxy.geyser.reversion.shaded.classtransform.exceptions.TransformerException;
import oxy.geyser.reversion.shaded.classtransform.targets.IInjectionTarget;
import oxy.geyser.reversion.shaded.classtransform.transformer.coprocessor.AnnotationCoprocessorList;
import oxy.geyser.reversion.shaded.classtransform.transformer.types.RemovingTargetAnnotationHandler;
import oxy.geyser.reversion.shaded.classtransform.utils.ASMUtils;
import oxy.geyser.reversion.shaded.classtransform.utils.Codifier;
import oxy.geyser.reversion.shaded.classtransform.utils.Types;

@ParametersAreNonnullByDefault
public class CInjectAnnotationHandler
extends RemovingTargetAnnotationHandler<CInject> {
    public CInjectAnnotationHandler() {
        super(CInject.class, CInject::method);
    }

    @Override
    public void transform(CInject annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod, MethodNode target) {
        boolean hasCallback;
        boolean hasArgs;
        AnnotationCoprocessorList coprocessors = transformerManager.getCoprocessors();
        transformerMethod = coprocessors.preprocess(transformerManager, transformedClass, target, transformer, transformerMethod);
        if (Modifier.isStatic(target.access) != Modifier.isStatic(transformerMethod.access)) {
            throw TransformerException.wrongStaticAccess(transformerMethod, transformer, Modifier.isStatic(target.access));
        }
        Type[] arguments = Types.argumentTypes(transformerMethod.desc);
        Type[] targetArguments = Types.argumentTypes(target.desc);
        if (arguments.length == 0) {
            hasArgs = false;
            hasCallback = false;
        } else if (arguments.length == 1 && ASMUtils.compareType(arguments[0], Types.type(InjectionCallback.class))) {
            hasArgs = false;
            hasCallback = true;
        } else if (ASMUtils.compareTypes(targetArguments, arguments)) {
            hasArgs = true;
            hasCallback = false;
        } else if (ASMUtils.compareTypes(targetArguments, arguments, false, Types.type(InjectionCallback.class))) {
            hasArgs = true;
            hasCallback = true;
        } else {
            throw new TransformerException(transformerMethod, transformer, "must have the same arguments as target method or no arguments with optional InjectionCallback").help(Codifier.of(target).param(Types.type(InjectionCallback.class)));
        }
        if (!Types.returnType(transformerMethod.desc).equals(Type.VOID_TYPE)) {
            throw TransformerException.mustReturnVoid(transformerMethod, transformer);
        }
        MethodNode copiedTransformerMethod = this.renameAndCopy(transformerMethod, target, transformer, transformedClass, "CInject");
        Map<String, IInjectionTarget> injectionTargets = transformerManager.getInjectionTargets();
        ArrayList<MethodInsnNode> transformerMethodCalls = new ArrayList<MethodInsnNode>();
        for (CTarget injectTarget : annotation.target()) {
            IInjectionTarget injectionTarget = injectionTargets.get(injectTarget.value().toUpperCase(Locale.ROOT));
            if (injectionTarget == null) {
                throw new InvalidTargetException(transformerMethod, transformer, injectTarget.target(), injectionTargets.keySet());
            }
            List<AbstractInsnNode> targetInstructions = injectionTarget.getTargets(injectionTargets, target, injectTarget, annotation.slice());
            CTarget.Shift shift = injectionTarget.getShift(injectTarget);
            if (targetInstructions == null) {
                throw new TransformerException(transformerMethod, transformer, "has invalid " + injectTarget.value() + " member declaration").help("e.g. Ljava/lang/String;toString()V, Ljava/lang/Integer;MAX_VALUE:I");
            }
            if (targetInstructions.isEmpty() && !injectTarget.optional()) {
                throw new TransformerException(transformerMethod, transformer, "target '" + injectTarget.value() + "' could not be found").help("e.g. Ljava/lang/String;toString()V, Ljava/lang/Integer;MAX_VALUE:I");
            }
            for (AbstractInsnNode instruction : targetInstructions) {
                InsnList instructions = instruction.getOpcode() >= 172 && instruction.getOpcode() <= 177 || instruction.getOpcode() == 191 ? this.getReturnInstructions(transformedClass, target, transformerMethod, annotation.cancellable(), hasArgs, hasCallback, transformerMethodCalls) : this.getCallInstructions(transformedClass, target, transformerMethod, annotation.cancellable(), hasArgs, hasCallback, transformerMethodCalls);
                if (shift == CTarget.Shift.BEFORE) {
                    target.instructions.insertBefore(instruction, instructions);
                    continue;
                }
                target.instructions.insert(instruction, instructions);
            }
        }
        coprocessors.postprocess(transformerManager, transformedClass, target, transformerMethodCalls, transformer, copiedTransformerMethod);
    }

    private InsnList getCallInstructions(ClassNode classNode, MethodNode target, MethodNode source, boolean cancellable, boolean hasArgs, boolean hasCallback, List<MethodInsnNode> transformerMethodCalls) {
        Type returnType = Types.returnType(target.desc);
        int callbackVar = ASMUtils.getFreeVarIndex(target);
        InsnList instructions = this.getLoadInstructions(target, hasArgs);
        this.createCallback(instructions, cancellable, hasCallback, callbackVar, Type.VOID_TYPE, 0);
        this.callInjectionMethod(instructions, classNode, target, source, transformerMethodCalls);
        this.getCancelInstructions(instructions, cancellable, hasCallback, callbackVar, returnType, -1);
        return instructions;
    }

    private InsnList getReturnInstructions(ClassNode classNode, MethodNode target, MethodNode source, boolean cancellable, boolean hasArgs, boolean hasCallback, List<MethodInsnNode> transformerMethodCalls) {
        Type returnType = Types.returnType(target.desc);
        boolean isVoid = returnType.equals(Type.VOID_TYPE);
        int callbackVar = ASMUtils.getFreeVarIndex(target);
        int returnVar = callbackVar + 1;
        InsnList instructions = this.getLoadInstructions(target, hasArgs);
        this.createCallback(instructions, cancellable, hasCallback, callbackVar, returnType, returnVar);
        this.callInjectionMethod(instructions, classNode, target, source, transformerMethodCalls);
        this.getCancelInstructions(instructions, cancellable, hasCallback, callbackVar, returnType, returnVar);
        if (!isVoid && hasCallback) {
            instructions.insert(new VarInsnNode(ASMUtils.getStoreOpcode(returnType), returnVar));
            if (!cancellable) {
                instructions.add(new VarInsnNode(ASMUtils.getLoadOpcode(returnType), returnVar));
            }
        }
        return instructions;
    }

    private InsnList getLoadInstructions(MethodNode methodNode, boolean hasArgs) {
        if (!hasArgs) {
            return new InsnList();
        }
        InsnList instructions = new InsnList();
        Type[] parameter = Types.argumentTypes(methodNode.desc);
        int index = Modifier.isStatic(methodNode.access) ? 0 : 1;
        for (Type type : parameter) {
            if (type.equals(Type.BOOLEAN_TYPE)) {
                instructions.add(new VarInsnNode(21, index));
                ++index;
                continue;
            }
            if (type.equals(Type.BYTE_TYPE)) {
                instructions.add(new VarInsnNode(21, index));
                ++index;
                continue;
            }
            if (type.equals(Type.SHORT_TYPE)) {
                instructions.add(new VarInsnNode(21, index));
                ++index;
                continue;
            }
            if (type.equals(Type.CHAR_TYPE)) {
                instructions.add(new VarInsnNode(21, index));
                ++index;
                continue;
            }
            if (type.equals(Type.INT_TYPE)) {
                instructions.add(new VarInsnNode(21, index));
                ++index;
                continue;
            }
            if (type.equals(Type.LONG_TYPE)) {
                instructions.add(new VarInsnNode(22, index));
                index += 2;
                continue;
            }
            if (type.equals(Type.FLOAT_TYPE)) {
                instructions.add(new VarInsnNode(23, index));
                ++index;
                continue;
            }
            if (type.equals(Type.DOUBLE_TYPE)) {
                instructions.add(new VarInsnNode(24, index));
                index += 2;
                continue;
            }
            instructions.add(new VarInsnNode(25, index));
            ++index;
        }
        return instructions;
    }

    private void createCallback(InsnList instructions, boolean cancellable, boolean hasCallback, int callbackVar, Type returnType, int returnVar) {
        if (!hasCallback) {
            return;
        }
        instructions.add(new TypeInsnNode(187, Types.internalName(InjectionCallback.class)));
        instructions.add(new InsnNode(89));
        instructions.add(new InsnNode(cancellable ? 4 : 3));
        if (!Type.VOID_TYPE.equals(returnType)) {
            instructions.add(new VarInsnNode(ASMUtils.getLoadOpcode(returnType), returnVar));
            AbstractInsnNode convertOpcode = ASMUtils.getPrimitiveToObject(returnType);
            if (convertOpcode != null) {
                instructions.add(convertOpcode);
            }
            instructions.add(new MethodInsnNode(183, Types.internalName(InjectionCallback.class), "<init>", Types.methodDescriptor(Void.TYPE, Boolean.TYPE, Object.class)));
        } else {
            instructions.add(new MethodInsnNode(183, Types.internalName(InjectionCallback.class), "<init>", Types.methodDescriptor(Void.TYPE, Boolean.TYPE)));
        }
        if (cancellable) {
            instructions.add(new VarInsnNode(58, callbackVar));
            instructions.add(new VarInsnNode(25, callbackVar));
        }
    }

    private void callInjectionMethod(InsnList instructions, ClassNode classNode, MethodNode target, MethodNode source, List<MethodInsnNode> transformerMethodCalls) {
        MethodInsnNode transformerCall;
        boolean isInterface = Modifier.isInterface(classNode.access);
        InsnList loadLocals = new InsnList();
        InsnList postExecuteInstructions = new InsnList();
        if (Modifier.isStatic(target.access)) {
            transformerCall = new MethodInsnNode(184, classNode.name, source.name, source.desc, isInterface);
        } else {
            transformerCall = new MethodInsnNode(isInterface ? 185 : 182, classNode.name, source.name, source.desc, isInterface);
            instructions.insert(new VarInsnNode(25, 0));
        }
        instructions.add(loadLocals);
        instructions.add(transformerCall);
        instructions.add(postExecuteInstructions);
        transformerMethodCalls.add(transformerCall);
    }

    private void getCancelInstructions(InsnList instructions, boolean cancellable, boolean hasCallback, int callbackVar, Type returnType, int returnVar) {
        if (!cancellable || !hasCallback) {
            return;
        }
        boolean willCancel = returnVar >= 0;
        InsnList cancelInstructions = new InsnList();
        LabelNode jump = new LabelNode();
        LabelNode end = new LabelNode();
        cancelInstructions.add(new VarInsnNode(25, callbackVar));
        cancelInstructions.add(new MethodInsnNode(182, Types.internalName(InjectionCallback.class), "isCancelled", Types.methodDescriptor(Boolean.TYPE, new Object[0])));
        cancelInstructions.add(new JumpInsnNode(153, jump));
        if (!Type.VOID_TYPE.equals(returnType)) {
            cancelInstructions.add(new VarInsnNode(25, callbackVar));
            cancelInstructions.add(new MethodInsnNode(182, Types.internalName(InjectionCallback.class), "getReturnValue", Types.methodDescriptor(Object.class, new Object[0])));
            cancelInstructions.add(ASMUtils.getCast(returnType));
            if (willCancel) {
                cancelInstructions.add(new JumpInsnNode(167, end));
            } else {
                cancelInstructions.add(new InsnNode(ASMUtils.getReturnOpcode(returnType)));
            }
        } else if (willCancel) {
            cancelInstructions.clear();
        } else {
            cancelInstructions.add(new InsnNode(177));
        }
        cancelInstructions.add(jump);
        if (willCancel && cancelInstructions.size() > 0) {
            cancelInstructions.add(new VarInsnNode(ASMUtils.getLoadOpcode(returnType), returnVar));
            cancelInstructions.add(end);
        }
        instructions.add(cancelInstructions);
    }
}

