/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.transformer.impl;

import java.lang.reflect.Modifier;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.asm.tree.ClassNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodNode;
import oxy.geyser.reversion.shaded.classtransform.TransformerManager;
import oxy.geyser.reversion.shaded.classtransform.annotations.injection.COverride;
import oxy.geyser.reversion.shaded.classtransform.exceptions.TransformerException;
import oxy.geyser.reversion.shaded.classtransform.transformer.types.RemovingTargetAnnotationHandler;
import oxy.geyser.reversion.shaded.classtransform.utils.ASMUtils;
import oxy.geyser.reversion.shaded.classtransform.utils.Types;
import oxy.geyser.reversion.shaded.classtransform.utils.mappings.Remapper;

@ParametersAreNonnullByDefault
public class COverrideAnnotationHandler
extends RemovingTargetAnnotationHandler<COverride> {
    public COverrideAnnotationHandler() {
        super(COverride.class, COverride::value);
    }

    @Override
    public void transform(COverride annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod, MethodNode target) {
        if (Modifier.isStatic(target.access) != Modifier.isStatic(transformerMethod.access)) {
            throw TransformerException.wrongStaticAccess(transformerMethod, transformer, Modifier.isStatic(target.access));
        }
        if (!ASMUtils.compareTypes(Types.argumentTypes(target.desc), Types.argumentTypes(transformerMethod.desc))) {
            throw TransformerException.wrongArguments(transformerMethod, transformer, Types.argumentTypes(target.desc));
        }
        if (ASMUtils.isAccessLower(transformerMethod.access, target.access)) {
            throw new TransformerException(transformerMethod, transformer, "must have higher/equal access than original method");
        }
        transformerMethod.name = target.name;
        transformerMethod.desc = target.desc;
        transformedClass.methods.remove(target);
        this.prepareForCopy(transformer, transformerMethod);
        Remapper.remapAndAdd(transformer, transformedClass, transformerMethod);
    }
}

