/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.asm.Type;
import oxy.geyser.reversion.shaded.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public class Codifier {
    private String access = "";
    private String returnType = "";
    private String name = "";
    private final List<String> parameters = new ArrayList<String>();
    private final List<String> exceptions = new ArrayList<String>();
    private String body = "";

    public static Codifier get() {
        return new Codifier();
    }

    public static Codifier of(MethodNode method) {
        return Codifier.get().access(method.access).returnType(Type.getReturnType(method.desc)).name(method.name).params(Type.getArgumentTypes(method.desc)).exceptions(method.exceptions == null ? new Type[]{} : (Type[])method.exceptions.stream().map(Type::getObjectType).toArray(Type[]::new));
    }

    private Codifier() {
    }

    public Codifier access(int access) {
        boolean isPublic = (access & 1) != 0;
        boolean isPrivate = (access & 2) != 0;
        boolean isProtected = (access & 4) != 0;
        boolean isStatic = (access & 8) != 0;
        this.access = "";
        if (isPublic) {
            this.access = this.access + "public";
        } else if (isPrivate) {
            this.access = this.access + "private";
        } else if (isProtected) {
            this.access = this.access + "protected";
        }
        if (isStatic) {
            this.access = this.access + (this.access.isEmpty() ? "" : " ") + "static";
        }
        return this;
    }

    public Codifier returnType(Type returnType) {
        this.returnType = returnType.getClassName();
        if (this.returnType.contains(".")) {
            this.returnType = this.stripPackage(this.returnType);
        }
        return this;
    }

    public Codifier name(String name) {
        this.name = name;
        return this;
    }

    public Codifier param(@Nullable Type parameter) {
        if (parameter == null) {
            this.parameters.clear();
            return this;
        }
        String className = this.stripPackage(parameter.getClassName());
        if (this.isJavaKeyword(className)) {
            className = className + " " + className.charAt(0);
        } else {
            String varName = className.substring(0, 1).toLowerCase() + className.substring(1);
            varName = varName.replace("[]", "Array");
            className = className + " " + varName;
        }
        int index = 2;
        String parameterName = className;
        while (this.parameters.contains(parameterName)) {
            parameterName = className + index++;
        }
        this.parameters.add(parameterName);
        return this;
    }

    public Codifier params(Type ... parameters) {
        for (Type type : parameters) {
            this.param(type);
        }
        return this;
    }

    public Codifier exception(@Nullable Type exception) {
        if (exception == null) {
            this.exceptions.clear();
            return this;
        }
        this.exceptions.add(this.stripPackage(exception.getClassName()));
        return this;
    }

    public Codifier exceptions(Type ... exceptions) {
        for (Type type : exceptions) {
            this.exception(type);
        }
        return this;
    }

    public Codifier body(String body) {
        this.body = body;
        return this;
    }

    public String build() {
        StringBuilder out = new StringBuilder();
        if (!this.access.isEmpty()) {
            out.append(this.access).append(" ");
        }
        if (!this.returnType.isEmpty()) {
            out.append(this.returnType).append(" ");
        }
        if (!this.name.isEmpty()) {
            out.append(this.name).append("(").append(String.join((CharSequence)", ", this.parameters)).append(")");
        }
        if (!this.exceptions.isEmpty()) {
            out.append(" throws ").append(String.join((CharSequence)", ", this.exceptions));
        }
        if (!this.body.isEmpty()) {
            out.append(" ").append(this.body);
        }
        return out.toString().trim();
    }

    private String stripPackage(String className) {
        if (className.contains(".")) {
            return className.substring(className.lastIndexOf(".") + 1);
        }
        return className;
    }

    private boolean isJavaKeyword(String s) {
        return s.equals("abstract") || s.equals("assert") || s.equals("boolean") || s.equals("break") || s.equals("byte") || s.equals("case") || s.equals("catch") || s.equals("char") || s.equals("class") || s.equals("const") || s.equals("continue") || s.equals("default") || s.equals("do") || s.equals("double") || s.equals("else") || s.equals("enum") || s.equals("extends") || s.equals("final") || s.equals("finally") || s.equals("float") || s.equals("for") || s.equals("goto") || s.equals("if") || s.equals("implements") || s.equals("import") || s.equals("instanceof") || s.equals("int") || s.equals("interface") || s.equals("long") || s.equals("native") || s.equals("new") || s.equals("package") || s.equals("private") || s.equals("protected") || s.equals("public") || s.equals("return") || s.equals("short") || s.equals("static") || s.equals("strictfp") || s.equals("super") || s.equals("switch") || s.equals("synchronized") || s.equals("this") || s.equals("throw") || s.equals("throws") || s.equals("transient") || s.equals("try") || s.equals("void") || s.equals("volatile") || s.equals("while");
    }
}

