/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.reflect.stream.constructor;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import oxy.geyser.reversion.shaded.reflect.Constructors;
import oxy.geyser.reversion.shaded.reflect.exceptions.ConstructorNotFoundException;
import oxy.geyser.reversion.shaded.reflect.stream.RStream;
import oxy.geyser.reversion.shaded.reflect.stream.constructor.ConstructorWrapper;

public class ConstructorStream {
    private final RStream parent;
    private final List<ConstructorWrapper> constructors;

    public ConstructorStream(RStream parent) {
        this.parent = parent;
        this.constructors = new ArrayList<ConstructorWrapper>();
        for (Constructor<?> constructor : Constructors.getDeclaredConstructors(parent.clazz())) {
            this.constructors.add(new ConstructorWrapper(this, constructor));
        }
    }

    private ConstructorStream(RStream parent, List<ConstructorWrapper> constructors) {
        this.parent = parent;
        this.constructors = constructors;
    }

    public RStream parent() {
        return this.parent;
    }

    public int size() {
        return this.constructors.size();
    }

    public Optional<ConstructorWrapper> opt(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            for (ConstructorWrapper constructor : this.constructors) {
                if (constructor.parameterTypes().length != 0) continue;
                return Optional.of(constructor);
            }
        } else {
            for (ConstructorWrapper constructor : this.constructors) {
                if (!Arrays.equals(constructor.parameterTypes(), parameterTypes)) continue;
                return Optional.of(constructor);
            }
        }
        return Optional.empty();
    }

    public Optional<ConstructorWrapper> opt(int index) {
        if (index < 0 || index > this.constructors.size()) {
            return Optional.empty();
        }
        return Optional.of(this.constructors.get(index));
    }

    public ConstructorWrapper by(Class<?> ... parameterTypes) {
        return this.opt(parameterTypes).orElseThrow(() -> new ConstructorNotFoundException(this.parent.clazz().getName(), parameterTypes));
    }

    public ConstructorWrapper by(int index) {
        return this.opt(index).orElseThrow(() -> new ConstructorNotFoundException(this.parent.clazz().getName(), String.valueOf(index)));
    }

    public ConstructorStream filter(Predicate<ConstructorWrapper> filter) {
        this.constructors.removeIf(filter.negate());
        return this;
    }

    public ConstructorStream filter(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return this.filter((ConstructorWrapper constructor) -> constructor.parameterCount() == 0);
        }
        return this.filter((ConstructorWrapper constructor) -> Arrays.equals(constructor.parameterTypes(), parameterTypes));
    }

    public ConstructorStream filter(boolean isStatic) {
        return this.filter((ConstructorWrapper constructor) -> constructor.modifier().isStatic() == isStatic);
    }

    public ConstructorStream filterAnnotation(Class<?> annotation) {
        return this.filter((ConstructorWrapper constructor) -> constructor.annotations().anyMatch(a -> a.annotationType().equals(annotation)));
    }

    public Iterator<ConstructorWrapper> iterator() {
        return this.constructors.iterator();
    }

    public <T> Stream<T> map(Function<ConstructorWrapper, T> mapFunction) {
        return this.jstream().map(mapFunction);
    }

    public Stream<ConstructorWrapper> jstream() {
        return this.constructors.stream();
    }

    public ConstructorStream forEach(Consumer<ConstructorWrapper> consumer) {
        this.constructors.forEach(consumer);
        return this;
    }

    public ConstructorStream copy() {
        return new ConstructorStream(this.parent, new ArrayList<ConstructorWrapper>(this.constructors));
    }
}

