/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.util;

import java.lang.reflect.Field;
import org.cloudburstmc.protocol.bedrock.BedrockServerSession;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.UpstreamSession;
import oxy.geyser.reversion.handler.TranslatorPacketHandler;
import oxy.geyser.reversion.handler.TranslatorSendListener;

public class GeyserUtil {
    public static void hook(GeyserSession session) {
        try {
            GeyserUtil.injectCloudburstUpstream(session, GeyserUtil.findCloudburstSession(session));
        }
        catch (Exception ignored) {
            session.disconnect("Failed to hook into cloudburst session!");
        }
    }

    private static void injectCloudburstUpstream(GeyserSession session, BedrockServerSession downstream) throws Exception {
        Field upstream = GeyserSession.class.getDeclaredField("upstream");
        upstream.setAccessible(true);
        TranslatorPacketHandler handler = (TranslatorPacketHandler)downstream.getPacketHandler();
        if (handler.getUser() == null) {
            return;
        }
        upstream.set(session, (Object)new TranslatorSendListener(handler.getUser(), downstream, (UpstreamSession)upstream.get(session)));
    }

    private static BedrockServerSession findCloudburstSession(GeyserSession connection) throws Exception {
        Field upstream = GeyserSession.class.getDeclaredField("upstream");
        upstream.setAccessible(true);
        Object session = upstream.get(connection);
        Field field = UpstreamSession.class.getDeclaredField("session");
        field.setAccessible(true);
        return (BedrockServerSession)field.get(session);
    }
}

