/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.cloudburstmc.netty.channel.raknet.RakChannelFactory;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.v748.Bedrock_v748;
import org.cloudburstmc.protocol.bedrock.codec.v766.Bedrock_v766;
import org.cloudburstmc.protocol.bedrock.codec.v776.Bedrock_v776;
import org.cloudburstmc.protocol.bedrock.codec.v786.Bedrock_v786;
import org.cloudburstmc.protocol.bedrock.codec.v818.Bedrock_v818;
import org.cloudburstmc.protocol.bedrock.data.EncodingSettings;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.bedrock.SessionLoginEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPostInitializeEvent;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.network.netty.Bootstraps;
import org.geysermc.geyser.network.netty.GeyserServer;
import org.geysermc.geyser.network.netty.handler.RakConnectionRequestHandler;
import org.geysermc.geyser.network.netty.handler.RakGeyserRateLimiter;
import org.geysermc.geyser.network.netty.handler.RakPingHandler;
import org.geysermc.geyser.network.netty.proxy.ProxyServerHandler;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.network.helper.TransportHelper;
import oxy.geyser.reversion.handler.init.TranslatorServerInitializer;
import oxy.geyser.reversion.util.GeyserUtil;
import oxy.toviabedrock.ToViaBedrock;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodec;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v729.Bedrock_v729;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v800.Bedrock_v800;

public class GeyserReversion
implements Extension {
    public static org.cloudburstmc.protocol.bedrock.codec.BedrockCodec OLDEST_GEYSER_CODEC = GeyserReversion.fixCodec(Bedrock_v818.CODEC);
    public static BedrockCodec OLDEST_GEYSER_OXY_CODEC;
    public static Map<Integer, org.cloudburstmc.protocol.bedrock.codec.BedrockCodec> OXY_CODEC_MAPPER;
    private static final TransportHelper.TransportType TRANSPORT;

    private static org.cloudburstmc.protocol.bedrock.codec.BedrockCodec fixCodec(org.cloudburstmc.protocol.bedrock.codec.BedrockCodec codec) {
        BedrockCodecHelper helper = codec.createHelper();
        helper.setEncodingSettings(EncodingSettings.builder().maxListSize(Integer.MAX_VALUE).maxByteArraySize(Integer.MAX_VALUE).maxNetworkNBTSize(Integer.MAX_VALUE).maxItemNBTSize(Integer.MAX_VALUE).maxStringLength(Integer.MAX_VALUE).build());
        return codec.toBuilder().helper(() -> helper).build();
    }

    @Subscribe
    public void onGeyserPostInitializeEvent(GeyserPostInitializeEvent event) {
        ToViaBedrock.init();
        GeyserImpl geyser = GeyserImpl.getInstance();
        geyser.getGeyserServer().shutdown();
        Integer bedrockThreadCount = Integer.getInteger("Geyser.BedrockNetworkThreads");
        if (bedrockThreadCount == null) {
            bedrockThreadCount = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(NettyRuntime.availableProcessors() * 2)));
        }
        EventLoopGroup group = (EventLoopGroup)TRANSPORT.eventLoopGroupFactory().apply(Bootstraps.isReusePortAvailable() ? Integer.getInteger("Geyser.ListenCount", 1) : 1, new DefaultThreadFactory("GeyserServer", true));
        EventLoopGroup childGroup = (EventLoopGroup)TRANSPORT.eventLoopGroupFactory().apply(bedrockThreadCount, new DefaultThreadFactory("GeyserServerChild", true));
        TranslatorServerInitializer serverInitializer = new TranslatorServerInitializer(geyser);
        int rakPacketLimit = this.positivePropOrDefault("Geyser.RakPacketLimit", 120);
        int rakGlobalPacketLimit = this.positivePropOrDefault("Geyser.RakGlobalPacketLimit", 100000);
        boolean rakSendCookie = Boolean.parseBoolean(System.getProperty("Geyser.RakSendCookie", "true"));
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channelFactory((ChannelFactory)RakChannelFactory.server((Class)TRANSPORT.datagramChannelClass()))).group(group, childGroup).option(RakChannelOption.RAK_HANDLE_PING, (Object)true)).option(RakChannelOption.RAK_MAX_MTU, (Object)geyser.getConfig().getMtu())).option(RakChannelOption.RAK_PACKET_LIMIT, (Object)rakPacketLimit)).option(RakChannelOption.RAK_GLOBAL_PACKET_LIMIT, (Object)rakGlobalPacketLimit)).option(RakChannelOption.RAK_SEND_COOKIE, (Object)rakSendCookie)).childHandler((ChannelHandler)serverInitializer);
        Bootstraps.setupBootstrap((AbstractBootstrap)bootstrap);
        Field field = GeyserServer.class.getDeclaredField("bootstrapFutures");
        field.setAccessible(true);
        GeyserConfiguration config = geyser.getConfig();
        ChannelFuture[] futures = (ChannelFuture[])field.get(geyser.getGeyserServer());
        for (int i = 0; i < futures.length; ++i) {
            ChannelFuture future = bootstrap.bind((SocketAddress)new InetSocketAddress(config.getBedrock().address(), config.getBedrock().port()));
            this.modifyHandlers(future);
            futures[i] = future;
        }
        Bootstraps.allOf((ChannelFuture[])futures).join();
        Field groupField = GeyserServer.class.getDeclaredField("group");
        groupField.setAccessible(true);
        groupField.set(geyser.getGeyserServer(), group);
        Field childGroupField = GeyserServer.class.getDeclaredField("childGroup");
        childGroupField.setAccessible(true);
        childGroupField.set(geyser.getGeyserServer(), childGroup);
        Field playerGroupField = GeyserServer.class.getDeclaredField("playerGroup");
        playerGroupField.setAccessible(true);
        playerGroupField.set(geyser.getGeyserServer(), serverInitializer.getEventLoopGroup());
    }

    @Subscribe
    public void onSessionJoin(SessionLoginEvent event) {
        GeyserUtil.hook((GeyserSession)event.connection());
    }

    private void modifyHandlers(ChannelFuture future) {
        boolean isWhitelistedProxyProtocol;
        Channel channel = future.channel();
        channel.pipeline().addFirst("rak-connection-request-handler", (ChannelHandler)new RakConnectionRequestHandler(GeyserImpl.getInstance().getGeyserServer())).addAfter("rak-offline-handler", "rak-ping-handler", (ChannelHandler)new RakPingHandler(GeyserImpl.getInstance().getGeyserServer()));
        boolean isProxyProtocol = GeyserImpl.getInstance().getConfig().getBedrock().isEnableProxyProtocol();
        if (isProxyProtocol) {
            channel.pipeline().addFirst("proxy-protocol-decoder", (ChannelHandler)new ProxyServerHandler());
        }
        boolean bl = isWhitelistedProxyProtocol = isProxyProtocol && !GeyserImpl.getInstance().getConfig().getBedrock().getProxyProtocolWhitelistedIPs().isEmpty();
        if (Boolean.parseBoolean(System.getProperty("Geyser.RakRateLimitingDisabled", "false")) || isWhitelistedProxyProtocol) {
            channel.pipeline().remove("rak-server-rate-limiter");
        } else {
            channel.pipeline().replace("rak-server-rate-limiter", "rak-geyser-rate-limiter", (ChannelHandler)new RakGeyserRateLimiter(channel));
        }
    }

    private int positivePropOrDefault(String property, int defaultValue) {
        String value = System.getProperty(property);
        try {
            int parsed;
            int n = parsed = value != null ? Integer.parseInt(value) : defaultValue;
            if (parsed < 1) {
                GeyserImpl.getInstance().getLogger().warning("Non-postive integer value for " + property + ": " + value + ". Using default value: " + defaultValue);
                return defaultValue;
            }
            return parsed;
        }
        catch (NumberFormatException e) {
            GeyserImpl.getInstance().getLogger().warning("Invalid integer value for " + property + ": " + value + ". Using default value: " + defaultValue);
            return defaultValue;
        }
    }

    static {
        oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper helper = oxy.toviabedrock.shaded.protocol.bedrock.codec.v818.Bedrock_v818.CODEC.createHelper();
        helper.setEncodingSettings(oxy.toviabedrock.shaded.protocol.bedrock.data.EncodingSettings.builder().maxListSize(Integer.MAX_VALUE).maxByteArraySize(Integer.MAX_VALUE).maxNetworkNBTSize(Integer.MAX_VALUE).maxItemNBTSize(Integer.MAX_VALUE).maxStringLength(Integer.MAX_VALUE).build());
        OLDEST_GEYSER_OXY_CODEC = oxy.toviabedrock.shaded.protocol.bedrock.codec.v818.Bedrock_v818.CODEC.toBuilder().helper(() -> helper).build();
        OXY_CODEC_MAPPER = new HashMap<Integer, org.cloudburstmc.protocol.bedrock.codec.BedrockCodec>();
        OXY_CODEC_MAPPER.put(oxy.toviabedrock.shaded.protocol.bedrock.codec.v818.Bedrock_v818.CODEC.getProtocolVersion(), GeyserReversion.fixCodec(Bedrock_v818.CODEC));
        OXY_CODEC_MAPPER.put(Bedrock_v800.CODEC.getProtocolVersion(), GeyserReversion.fixCodec(org.cloudburstmc.protocol.bedrock.codec.v800.Bedrock_v800.CODEC));
        OXY_CODEC_MAPPER.put(oxy.toviabedrock.shaded.protocol.bedrock.codec.v786.Bedrock_v786.CODEC.getProtocolVersion(), GeyserReversion.fixCodec(Bedrock_v786.CODEC));
        OXY_CODEC_MAPPER.put(oxy.toviabedrock.shaded.protocol.bedrock.codec.v776.Bedrock_v776.CODEC.getProtocolVersion(), GeyserReversion.fixCodec(Bedrock_v776.CODEC));
        OXY_CODEC_MAPPER.put(oxy.toviabedrock.shaded.protocol.bedrock.codec.v766.Bedrock_v766.CODEC.getProtocolVersion(), GeyserReversion.fixCodec(Bedrock_v766.CODEC));
        OXY_CODEC_MAPPER.put(oxy.toviabedrock.shaded.protocol.bedrock.codec.v748.Bedrock_v748.CODEC.getProtocolVersion(), GeyserReversion.fixCodec(Bedrock_v748.CODEC));
        OXY_CODEC_MAPPER.put(Bedrock_v729.CODEC.getProtocolVersion(), GeyserReversion.fixCodec(org.cloudburstmc.protocol.bedrock.codec.v729.Bedrock_v729.CODEC));
        TRANSPORT = TransportHelper.TRANSPORT_TYPE;
    }
}

