/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.handler;

import lombok.NonNull;
import org.cloudburstmc.protocol.bedrock.BedrockServerSession;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ItemComponentPacket;
import org.geysermc.geyser.session.UpstreamSession;
import oxy.geyser.reversion.GeyserReversion;
import oxy.geyser.reversion.session.GeyserTranslatedUser;
import oxy.geyser.reversion.util.PacketUtil;

public final class TranslatorSendListener
extends UpstreamSession {
    private final GeyserTranslatedUser user;
    private final UpstreamSession oldSession;

    public TranslatorSendListener(GeyserTranslatedUser user, BedrockServerSession session, UpstreamSession oldSession) {
        super(session);
        this.oldSession = oldSession;
        this.user = user;
    }

    public void disconnect(String reason) {
        this.oldSession.disconnect(reason);
    }

    public void sendPacket(@NonNull BedrockPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (packet instanceof ItemComponentPacket) {
            ItemComponentPacket componentPacket = (ItemComponentPacket)packet;
            if (this.user != null) {
                this.user.setItemDefinitions(componentPacket);
            }
        }
        if (this.user != null) {
            oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacket oxyPacket = PacketUtil.toOxyNew(this.user, packet);
            if (oxyPacket != null) {
                this.user.getWorldReader().onClientbound(oxyPacket);
                oxyPacket = this.user.translateClientbound(oxyPacket);
                BedrockPacket translated = PacketUtil.toCloudburstOld(this.user, oxyPacket);
                if (translated != null) {
                    super.sendPacket(translated);
                }
            }
        } else {
            super.sendPacket(packet);
        }
    }

    public void sendPacketImmediately(@NonNull BedrockPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (this.user != null) {
            oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacket oxyPacket = PacketUtil.toOxyNew(this.user, packet);
            if (oxyPacket != null) {
                this.user.getWorldReader().onClientbound(oxyPacket);
                oxyPacket = this.user.translateClientbound(oxyPacket);
                BedrockPacket translated = PacketUtil.toCloudburstOld(this.user, oxyPacket);
                if (translated != null) {
                    super.sendPacketImmediately(translated);
                }
            }
        } else {
            super.sendPacketImmediately(packet);
        }
    }

    public int getProtocolVersion() {
        return this.user == null ? super.getProtocolVersion() : GeyserReversion.OLDEST_GEYSER_CODEC.getProtocolVersion();
    }
}

