/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.session;

import lombok.Generated;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ItemComponentPacket;
import org.cloudburstmc.protocol.common.Definition;
import org.cloudburstmc.protocol.common.DefinitionRegistry;
import org.cloudburstmc.protocol.common.SimpleDefinitionRegistry;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import oxy.geyser.reversion.GeyserReversion;
import oxy.geyser.reversion.util.PacketUtil;
import oxy.toviabedrock.ToViaBedrock;
import oxy.toviabedrock.base.registry.BlockDefinitionRegistryMapper;
import oxy.toviabedrock.session.UserSession;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodec;
import oxy.toviabedrock.shaded.protocol.bedrock.data.definitions.SimpleItemDefinition;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.ItemVersion;
import oxy.toviabedrock.shaded.protocol.common.SimpleDefinitionRegistry;

public class GeyserTranslatedUser
extends UserSession {
    private final GeyserSession session;
    private final BedrockCodec codec;
    private final org.cloudburstmc.protocol.bedrock.codec.BedrockCodec cloudburstCodec;
    private final BedrockCodecHelper cloudburstHelper;
    private final oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper helper;
    private final oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper latestHelper;
    private final BedrockCodecHelper cloudburstLatestHelper;

    public GeyserTranslatedUser(int protocolVersion, int serverVersion, GeyserSession session) {
        super(protocolVersion, serverVersion);
        this.session = session;
        this.codec = ToViaBedrock.getCodec(protocolVersion);
        this.cloudburstCodec = GeyserReversion.OXY_CODEC_MAPPER.get(protocolVersion);
        this.helper = this.codec.createHelper();
        this.latestHelper = GeyserReversion.OLDEST_GEYSER_OXY_CODEC.createHelper();
        this.cloudburstLatestHelper = GeyserReversion.OLDEST_GEYSER_CODEC.createHelper();
        this.cloudburstHelper = this.cloudburstCodec.createHelper();
        this.helper.setBlockDefinitions(new BlockDefinitionRegistryMapper(this));
        this.latestHelper.setBlockDefinitions(this.helper.getBlockDefinitions());
        this.cloudburstHelper.setBlockDefinitions((DefinitionRegistry)new DefinitionRegistry<BlockDefinition>(){

            public BlockDefinition getDefinition(int runtimeId) {
                return () -> runtimeId;
            }

            public boolean isRegistered(BlockDefinition definition) {
                return true;
            }
        });
        this.cloudburstLatestHelper.setBlockDefinitions(this.cloudburstHelper.getBlockDefinitions());
    }

    public void setItemDefinitions(ItemComponentPacket packet) {
        SimpleDefinitionRegistry.Builder builder = org.cloudburstmc.protocol.common.SimpleDefinitionRegistry.builder().add((Definition)new org.cloudburstmc.protocol.bedrock.data.definitions.SimpleItemDefinition("minecraft:empty", 0, false));
        for (ItemDefinition definition : packet.getItems()) {
            builder.add((Definition)new org.cloudburstmc.protocol.bedrock.data.definitions.SimpleItemDefinition(definition.getIdentifier(), definition.getRuntimeId(), definition.getVersion(), definition.isComponentBased(), definition.getComponentData()));
        }
        org.cloudburstmc.protocol.common.SimpleDefinitionRegistry itemDefinitions = builder.build();
        this.cloudburstHelper.setItemDefinitions((DefinitionRegistry)itemDefinitions);
        this.cloudburstLatestHelper.setItemDefinitions((DefinitionRegistry)itemDefinitions);
        SimpleDefinitionRegistry.Builder<SimpleItemDefinition> builder1 = SimpleDefinitionRegistry.builder().add(new SimpleItemDefinition("minecraft:empty", 0, false));
        for (ItemDefinition definition : packet.getItems()) {
            builder1.add(new SimpleItemDefinition(definition.getIdentifier(), definition.getRuntimeId(), ItemVersion.from(definition.getVersion().ordinal()), definition.isComponentBased(), definition.getComponentData()));
        }
        SimpleDefinitionRegistry<oxy.toviabedrock.shaded.protocol.bedrock.data.definitions.ItemDefinition> itemDefinitions1 = builder1.build();
        this.helper.setItemDefinitions(itemDefinitions1);
        this.latestHelper.setItemDefinitions(itemDefinitions1);
    }

    @Override
    public void sendUpstreamPacket(oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacket bedrockPacket, boolean immediately) {
        BedrockPacket packet = PacketUtil.toCloudburstOld(this, bedrockPacket);
        if (packet == null) {
            return;
        }
        if (immediately) {
            this.session.sendUpstreamPacketImmediately(packet);
        } else {
            this.session.sendUpstreamPacket(packet);
        }
    }

    @Override
    public void sendDownstreamPacket(oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacket bedrockPacket, boolean immediately) {
        BedrockPacket packet = PacketUtil.toCloudburstOld(this, bedrockPacket);
        if (packet == null) {
            return;
        }
        Registries.BEDROCK_PACKET_TRANSLATORS.translate(packet.getClass(), (Object)packet, this.session, false);
    }

    @Generated
    public GeyserSession getSession() {
        return this.session;
    }

    @Generated
    public BedrockCodec getCodec() {
        return this.codec;
    }

    @Generated
    public org.cloudburstmc.protocol.bedrock.codec.BedrockCodec getCloudburstCodec() {
        return this.cloudburstCodec;
    }

    @Generated
    public BedrockCodecHelper getCloudburstHelper() {
        return this.cloudburstHelper;
    }

    @Generated
    public oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper getHelper() {
        return this.helper;
    }

    @Generated
    public oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper getLatestHelper() {
        return this.latestHelper;
    }

    @Generated
    public BedrockCodecHelper getCloudburstLatestHelper() {
        return this.cloudburstLatestHelper;
    }
}

