/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.api.chunks.bitarray;

import oxy.toviabedrock.api.chunks.bitarray.BitArray;
import oxy.toviabedrock.api.chunks.bitarray.PaddedBitArray;
import oxy.toviabedrock.api.chunks.bitarray.Pow2BitArray;
import oxy.toviabedrock.api.chunks.bitarray.SingletonBitArray;
import oxy.toviabedrock.utils.MathUtils;

public enum BitArrayVersion {
    V16(16, 2, null),
    V8(8, 4, V16),
    V6(6, 5, V8),
    V5(5, 6, V6),
    V4(4, 8, V5),
    V3(3, 10, V4),
    V2(2, 16, V3),
    V1(1, 32, V2),
    V0(0, 0, V1);

    private static final BitArrayVersion[] VALUES;
    public final byte bits;
    public final byte entriesPerWord;
    public final int maxEntryValue;
    public final BitArrayVersion next;

    private BitArrayVersion(int bits, int entriesPerWord, BitArrayVersion next) {
        this.bits = (byte)bits;
        this.entriesPerWord = (byte)entriesPerWord;
        this.maxEntryValue = (1 << this.bits) - 1;
        this.next = next;
    }

    public static BitArrayVersion get(int version, boolean read) {
        for (BitArrayVersion ver : BitArrayVersion.values()) {
            if ((read || ver.entriesPerWord > version) && (!read || ver.bits != version)) continue;
            return ver;
        }
        throw new IllegalArgumentException("Invalid palette version: " + version);
    }

    public static BitArrayVersion forBitsCeil(int bits) {
        for (int i = VALUES.length - 1; i >= 0; --i) {
            BitArrayVersion version = VALUES[i];
            if (version.bits < bits) continue;
            return version;
        }
        return null;
    }

    public byte getId() {
        return this.bits;
    }

    public int getMaxEntryValue() {
        return this.maxEntryValue;
    }

    public BitArrayVersion next() {
        return this.next;
    }

    public BitArray createArray(int size) {
        return this.createArray(size, new int[MathUtils.ceil((float)size / (float)this.entriesPerWord)]);
    }

    public BitArray createArray(int size, int[] words) {
        if (this == V3 || this == V5 || this == V6) {
            return new PaddedBitArray(this, size, words);
        }
        if (this == V0) {
            return SingletonBitArray.INSTANCE;
        }
        return new Pow2BitArray(this, size, words);
    }

    static {
        VALUES = BitArrayVersion.values();
    }
}

