/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.api.chunks.palettes;

import oxy.toviabedrock.api.chunks.BaseDataPalette;
import oxy.toviabedrock.api.chunks.bitarray.BitArray;
import oxy.toviabedrock.api.chunks.bitarray.BitArrayVersion;
import oxy.toviabedrock.shaded.fastutil.ints.IntArrayList;
import oxy.toviabedrock.shaded.fastutil.ints.IntList;

public class NewDataPalette
implements BaseDataPalette<NewDataPalette> {
    private final IntList palette;
    private BitArray bitArray;

    public NewDataPalette(int airBlockId) {
        this(airBlockId, BitArrayVersion.V2);
    }

    public NewDataPalette(int airBlockId, BitArrayVersion version) {
        this.bitArray = version.createArray(4096);
        this.palette = new IntArrayList(16);
        this.palette.add(airBlockId);
    }

    public NewDataPalette(BitArray bitArray, IntList palette) {
        this.palette = palette;
        this.bitArray = bitArray;
    }

    @Override
    public int get(int index) {
        if (this.palette.isEmpty()) {
            return -1;
        }
        return this.palette.getInt(this.bitArray.get(index));
    }

    @Override
    public void set(int index, int id) {
        try {
            this.bitArray.set(index, this.idFor(id));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public NewDataPalette copy() {
        return new NewDataPalette(this.bitArray.copy(), new IntArrayList(this.palette));
    }

    private int idFor(int runtimeId) {
        BitArrayVersion next;
        int index = this.palette.indexOf(runtimeId);
        if (index != -1) {
            return index;
        }
        index = this.palette.size();
        this.palette.add(runtimeId);
        BitArrayVersion version = this.bitArray.getVersion();
        if (index > version.getMaxEntryValue() && (next = version.next()) != null) {
            this.onResize(next);
        }
        return index;
    }

    private void onResize(BitArrayVersion version) {
        BitArray newBitArray = version.createArray(4096);
        for (int i = 0; i < 4096; ++i) {
            newBitArray.set(i, this.bitArray.get(i));
        }
        this.bitArray = newBitArray;
    }
}

