/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.api.chunks.palettes;

import oxy.toviabedrock.api.chunks.BaseDataPalette;
import oxy.toviabedrock.api.chunks.NibbleArray;
import oxy.toviabedrock.shaded.lombok.Generated;

public class OlderDataPalette
implements BaseDataPalette<OlderDataPalette> {
    private final byte[] blocks;
    private final NibbleArray data;

    public OlderDataPalette() {
        this.blocks = new byte[4096];
        this.data = new NibbleArray(this.blocks.length);
    }

    public OlderDataPalette(byte[] blocks, NibbleArray data) {
        this.blocks = blocks;
        this.data = data;
    }

    @Override
    public int get(int index) {
        return (this.blocks[index] & 0xFF) << 4 | this.data.get(index);
    }

    @Override
    public void set(int index, int id) {
        if (id >> 4 > 255) {
            throw new IllegalArgumentException("Too large block id: " + id);
        }
        this.blocks[index] = (byte)(id >> 4);
        this.data.set(index, id & 0xF);
    }

    @Override
    public OlderDataPalette copy() {
        return new OlderDataPalette(this.blocks, new NibbleArray(this.data.getHandle()));
    }

    @Generated
    public byte[] getBlocks() {
        return this.blocks;
    }

    @Generated
    public NibbleArray getData() {
        return this.data;
    }
}

