/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import oxy.toviabedrock.ToViaBedrock;
import oxy.toviabedrock.base.Mapper;
import oxy.toviabedrock.base.WrappedBedrockPacket;
import oxy.toviabedrock.session.UserSession;
import oxy.toviabedrock.shaded.lombok.Generated;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodec;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacketType;

public class ProtocolToProtocol {
    private final BedrockCodec originalCodec;
    private final BedrockCodec translatedCodec;
    private final List<Class<? extends BedrockPacket>> ignoredClientBounds = new ArrayList<Class<? extends BedrockPacket>>();
    private final List<Class<? extends BedrockPacket>> ignoredServerBounds = new ArrayList<Class<? extends BedrockPacket>>();
    private final List<BedrockPacketType> directPassthroughClientBounds = new ArrayList<BedrockPacketType>();
    private final List<BedrockPacketType> directPassthroughServerBounds = new ArrayList<BedrockPacketType>();
    private final Map<Class<? extends BedrockPacket>, Consumer<WrappedBedrockPacket>> mappedClientBounds = new HashMap<Class<? extends BedrockPacket>, Consumer<WrappedBedrockPacket>>();
    private final Map<Class<? extends BedrockPacket>, Consumer<WrappedBedrockPacket>> mappedServerBounds = new HashMap<Class<? extends BedrockPacket>, Consumer<WrappedBedrockPacket>>();
    protected final List<Mapper> mappers = new ArrayList<Mapper>();

    public ProtocolToProtocol(BedrockCodec originalCodec, BedrockCodec translatedCodec) {
        this.originalCodec = originalCodec;
        this.translatedCodec = translatedCodec;
        this.registerProtocol();
        this.initMappers();
    }

    public void initMappers() {
        this.mappers.forEach(Mapper::registerProtocol);
    }

    public void init(UserSession session) {
        this.mappers.forEach(mapper -> mapper.init(session));
    }

    protected void registerProtocol() {
    }

    public void unmapDirectlyClientbound(BedrockPacketType type) {
        this.directPassthroughClientBounds.remove((Object)type);
    }

    public void unmapDirectlyServerbound(BedrockPacketType type) {
        this.directPassthroughServerBounds.remove((Object)type);
    }

    public void mapDirectlyClientbound(BedrockPacketType type) {
        this.directPassthroughClientBounds.add(type);
    }

    public void mapDirectlyServerbound(BedrockPacketType type) {
        this.directPassthroughServerBounds.add(type);
    }

    public void ignoreClientbound(Class<? extends BedrockPacket> klass) {
        this.ignoredClientBounds.add(klass);
    }

    public void ignoreServerbound(Class<? extends BedrockPacket> klass) {
        this.ignoredServerBounds.add(klass);
    }

    public void registerClientbound(Class<? extends BedrockPacket> klass, Consumer<WrappedBedrockPacket> consumer) {
        if (this.mappedClientBounds.containsKey(klass)) {
            this.mappedClientBounds.put(klass, this.mappedClientBounds.get(klass).andThen(consumer));
            return;
        }
        this.mappedClientBounds.put(klass, consumer);
    }

    public void registerServerbound(Class<? extends BedrockPacket> klass, Consumer<WrappedBedrockPacket> consumer) {
        if (this.mappedServerBounds.containsKey(klass)) {
            this.mappedServerBounds.put(klass, this.mappedServerBounds.get(klass).andThen(consumer));
            return;
        }
        this.mappedServerBounds.put(klass, consumer);
    }

    public boolean passthroughClientbound(WrappedBedrockPacket wrapped) {
        Consumer<WrappedBedrockPacket> translator = this.mappedClientBounds.get(wrapped.getPacket().getClass());
        if (translator == null) {
            if (!this.ignoredClientBounds.contains(wrapped.getPacket().getClass())) {
                if (this.directPassthroughClientBounds.contains((Object)wrapped.getPacket().getPacketType())) {
                    return true;
                }
                ToViaBedrock.getLogger().warning("Server sent an packet that we don't have a translator for: " + String.valueOf(wrapped.getPacket().getClass()) + "!");
            }
            return false;
        }
        translator.accept(wrapped);
        return true;
    }

    public boolean passthroughServerbound(WrappedBedrockPacket wrapped) {
        Consumer<WrappedBedrockPacket> translator = this.mappedServerBounds.get(wrapped.getPacket().getClass());
        if (translator == null) {
            if (!this.ignoredServerBounds.contains(wrapped.getPacket().getClass())) {
                if (this.directPassthroughServerBounds.contains((Object)wrapped.getPacket().getPacketType())) {
                    return true;
                }
                ToViaBedrock.getLogger().warning("Client sent an packet that we don't have a translator for: " + String.valueOf(wrapped.getPacket().getClass()) + "!");
            }
            return false;
        }
        translator.accept(wrapped);
        return true;
    }

    @Generated
    public BedrockCodec getOriginalCodec() {
        return this.originalCodec;
    }

    @Generated
    public BedrockCodec getTranslatedCodec() {
        return this.translatedCodec;
    }

    @Generated
    public List<Mapper> getMappers() {
        return this.mappers;
    }
}

