/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.base.mappers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import oxy.toviabedrock.base.Mapper;
import oxy.toviabedrock.base.ProtocolToProtocol;
import oxy.toviabedrock.protocols.v844to827.Protocol844to827;
import oxy.toviabedrock.session.UserSession;
import oxy.toviabedrock.session.storage.impl.GameSessionStorage;
import oxy.toviabedrock.shaded.gson.JsonObject;
import oxy.toviabedrock.shaded.gson.JsonParser;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.StartGamePacket;

public class BaseBlockMapper
extends Mapper {
    protected final Map<Integer, Integer> mappedBlockIds = new HashMap<Integer, Integer>();
    protected final Map<Integer, Integer> mappedHashedBlockIds = new HashMap<Integer, Integer>();

    public BaseBlockMapper(ProtocolToProtocol translator) {
        super(translator);
        this.initBlockMappings();
    }

    protected void initBlockMappings() {
    }

    protected final void loadHashedBlockMappingFromFile(String path) {
        try {
            String jsonString = new String(Objects.requireNonNull(Protocol844to827.class.getResourceAsStream("/blocks/" + path)).readAllBytes());
            JsonObject object = JsonParser.parseString(jsonString).getAsJsonObject();
            for (String key : object.keySet()) {
                this.mappedHashedBlockIds.put(Integer.valueOf(key), object.get(key).getAsInt());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected final void loadBlockMappingFromFile(String path) {
        try {
            String jsonString = new String(Objects.requireNonNull(Protocol844to827.class.getResourceAsStream("/blocks/" + path)).readAllBytes());
            JsonObject object = JsonParser.parseString(jsonString).getAsJsonObject();
            for (String key : object.keySet()) {
                this.mappedBlockIds.put(Integer.valueOf(key), object.get(key).getAsInt());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void registerProtocol() {
        this.registerClientbound(StartGamePacket.class, wrapped -> {
            StartGamePacket packet = (StartGamePacket)wrapped.getPacket();
            packet.setBlockRegistryChecksum(0L);
        });
    }

    public int mapBlockIdOrHashedId(UserSession user, int id) {
        if (user.get(GameSessionStorage.class).isBlockNetworkIdsHashed()) {
            return this.mappedHashedBlockIds.getOrDefault(id, id);
        }
        return this.mappedBlockIds.getOrDefault(id, id);
    }
}

