/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.base.mappers;

import java.util.HashMap;
import java.util.Map;
import oxy.toviabedrock.base.Mapper;
import oxy.toviabedrock.base.ProtocolToProtocol;
import oxy.toviabedrock.base.mappers.storage.BaseEntityRemappingStorage;
import oxy.toviabedrock.session.UserSession;
import oxy.toviabedrock.shaded.protocol.bedrock.data.entity.EntityDataTypes;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.AddEntityPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.AvailableEntityIdentifiersPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.RemoveEntityPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.SetEntityDataPacket;

public class BaseEntityMapper
extends Mapper {
    protected final Map<String, MappedEntity> identifierToMapped = new HashMap<String, MappedEntity>();

    public BaseEntityMapper(ProtocolToProtocol translator) {
        super(translator);
        this.initEntityMappings();
    }

    protected void initEntityMappings() {
    }

    @Override
    public void init(UserSession session) {
        if (session.get(BaseEntityRemappingStorage.class) == null) {
            session.put(new BaseEntityRemappingStorage(session));
        }
    }

    @Override
    protected void registerProtocol() {
        this.registerClientbound(AvailableEntityIdentifiersPacket.class, wrapped -> {
            AvailableEntityIdentifiersPacket packet = (AvailableEntityIdentifiersPacket)wrapped.getPacket();
        });
        this.registerClientbound(RemoveEntityPacket.class, wrapped -> {
            RemoveEntityPacket packet = (RemoveEntityPacket)wrapped.getPacket();
            wrapped.session().get(BaseEntityRemappingStorage.class).remove(packet.getUniqueEntityId());
        });
        this.registerClientbound(AddEntityPacket.class, wrapped -> {
            AddEntityPacket packet = (AddEntityPacket)wrapped.getPacket();
            MappedEntity mappedEntity = this.identifierToMapped.get(packet.getIdentifier());
            BaseEntityRemappingStorage storage = wrapped.session().get(BaseEntityRemappingStorage.class);
            if (mappedEntity != null) {
                storage.add(packet.getRuntimeEntityId(), packet.getUniqueEntityId(), packet.getIdentifier(), mappedEntity.showRealName);
                if (mappedEntity.showRealName) {
                    packet.getMetadata().put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, (Object)1);
                    CharSequence name = packet.getMetadata().get(EntityDataTypes.NAME);
                    if (name == null || name.isEmpty()) {
                        packet.getMetadata().put(EntityDataTypes.NAME, (Object)packet.getIdentifier());
                    }
                }
                packet.setIdentifier(mappedEntity.identifier);
            }
        });
        this.registerClientbound(SetEntityDataPacket.class, wrapped -> {
            SetEntityDataPacket packet = (SetEntityDataPacket)wrapped.getPacket();
            MappedEntity reverseMapped = wrapped.session().get(BaseEntityRemappingStorage.class).getIdentifier(packet.getRuntimeEntityId());
            if (reverseMapped == null) {
                return;
            }
            if (reverseMapped.showRealName) {
                packet.getMetadata().put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, (Object)1);
                CharSequence name = packet.getMetadata().get(EntityDataTypes.NAME);
                if (name == null || name.isEmpty()) {
                    packet.getMetadata().put(EntityDataTypes.NAME, (Object)reverseMapped.identifier);
                }
            }
        });
    }

    public record MappedEntity(String identifier, boolean showRealName) {
    }
}

