/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.base.mappers;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import oxy.toviabedrock.base.Mapper;
import oxy.toviabedrock.base.ProtocolToProtocol;
import oxy.toviabedrock.base.mappers.storage.BaseItemRemappingStorage;
import oxy.toviabedrock.session.UserSession;
import oxy.toviabedrock.shaded.gson.JsonObject;
import oxy.toviabedrock.shaded.gson.JsonParser;
import oxy.toviabedrock.shaded.protocol.bedrock.data.definitions.ItemDefinition;
import oxy.toviabedrock.shaded.protocol.bedrock.data.definitions.SimpleItemDefinition;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.ItemData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.transaction.InventoryActionData;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.AddItemEntityPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.InventoryContentPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.InventorySlotPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.InventoryTransactionPacket;
import oxy.toviabedrock.utils.HashMapWithHashed;
import oxy.toviabedrock.utils.definition.TOVBItemData;

public class BaseItemMapper
extends Mapper {
    protected final Map<String, String> identifierToIdentifier = new HashMap<String, String>();
    protected final HashMapWithHashed<String, String> itemIdentifierToMappedIdentifier = new HashMapWithHashed();
    protected final List<ItemMapper> itemDataMapper = new ArrayList<ItemMapper>();

    public BaseItemMapper(ProtocolToProtocol translator) {
        super(translator);
        this.initItemMappings();
    }

    protected void initItemMappings() {
    }

    protected final void loadItemMappingsFromFile(String name) {
        try {
            String jsonString = new String(Objects.requireNonNull(BaseItemMapper.class.getResourceAsStream("/items/" + name)).readAllBytes());
            JsonObject object = JsonParser.parseString(jsonString).getAsJsonObject();
            for (String key : object.keySet()) {
                this.itemIdentifierToMappedIdentifier.put(key, object.get(key).getAsString());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected void registerProtocol() {
        this.registerServerbound(InventoryTransactionPacket.class, wrapped -> {
            InventoryTransactionPacket packet = (InventoryTransactionPacket)wrapped.getPacket();
            packet.setItemInHand(this.reverseItemMapFromHash(wrapped.session(), packet.getItemInHand()));
            for (int i = 0; i < packet.getActions().size(); ++i) {
                InventoryActionData action = packet.getActions().get(i);
                packet.getActions().set(i, new InventoryActionData(action.getSource(), action.getSlot(), this.reverseItemMapFromHash(wrapped.session(), action.getFromItem()), this.reverseItemMapFromHash(wrapped.session(), action.getToItem()), action.getStackNetworkId()));
            }
        });
        this.registerClientbound(AddItemEntityPacket.class, wrapped -> {
            AddItemEntityPacket packet = (AddItemEntityPacket)wrapped.getPacket();
            packet.setItemInHand(this.mapItemAndApplyHash(wrapped.session(), packet.getItemInHand()));
        });
        this.registerClientbound(InventoryContentPacket.class, wrapped -> {
            InventoryContentPacket packet = (InventoryContentPacket)wrapped.getPacket();
            for (int i = 0; i < packet.getContents().size(); ++i) {
                ItemData itemData = packet.getContents().get(i);
                ItemData mapped = this.mapItemAndApplyHash(wrapped.session(), itemData);
                if (mapped == itemData) continue;
                packet.getContents().set(i, mapped);
            }
        });
        this.registerClientbound(InventorySlotPacket.class, wrapped -> {
            InventorySlotPacket packet = (InventorySlotPacket)wrapped.getPacket();
            packet.setItem(this.mapItemAndApplyHash(wrapped.session(), packet.getItem()));
        });
    }

    public ItemDefinition mapItemDefinitionWithOldIdentifier(UserSession session, ItemDefinition definition) {
        if (definition == null) {
            return null;
        }
        String identifier = (String)this.itemIdentifierToMappedIdentifier.get(definition.getIdentifier());
        if (identifier == null) {
            return null;
        }
        ItemDefinition mapped = session.get(BaseItemRemappingStorage.class).getDefinition(identifier);
        if (mapped == null) {
            return null;
        }
        NbtMapBuilder mapBuilder = NbtMap.builder();
        mapBuilder.put("TOVBHash", (Object)definition.getIdentifier().hashCode());
        String oldIdentifier = this.identifierToIdentifier.get(definition.getIdentifier());
        return new SimpleItemDefinition(oldIdentifier != null ? oldIdentifier : mapped.getIdentifier(), mapped.getRuntimeId(), mapped.getVersion(), mapped.isComponentBased(), mapBuilder.build());
    }

    protected ItemData mapItemAndApplyHash(UserSession session, ItemData data) {
        if (data == null) {
            return null;
        }
        ItemDefinition mapped = this.mapItemDefinitionWithOldIdentifier(session, data.getDefinition());
        if (mapped == null) {
            return data;
        }
        NbtMap originalTag = data.getTag() == null ? NbtMap.builder().build() : data.getTag();
        NbtMapBuilder nbtBuilder = originalTag.toBuilder();
        NbtMapBuilder display = originalTag.containsKey((Object)"display") ? originalTag.getCompound("display").toBuilder() : NbtMap.builder();
        int hashed = data.getDefinition().getIdentifier().hashCode();
        if (display.build().containsKey((Object)"Lore")) {
            ArrayList<CallSite> lore = new ArrayList<CallSite>(display.build().getList("lore", NbtType.STRING));
            lore.add((CallSite)((Object)("\u00a7r\u00a77Item mapped from: " + data.getDefinition().getIdentifier() + " (" + hashed + ").")));
            display.putList("Lore", NbtType.STRING, lore);
        } else {
            display.putList("Lore", NbtType.STRING, List.of("\u00a7r\u00a77Item mapped from: " + data.getDefinition().getIdentifier() + " (" + hashed + ")."));
        }
        nbtBuilder.put("display", (Object)display.build());
        nbtBuilder.put("TOVBHash", (Object)hashed);
        TOVBItemData itemData = new TOVBItemData(mapped, data.getDamage(), data.getCount(), nbtBuilder.build(), data.getCanPlace(), data.getCanBreak(), data.getBlockingTicks(), data.getBlockDefinition(), data.isUsingNetId(), data.getNetId());
        for (ItemMapper mapper : this.itemDataMapper) {
            itemData = mapper.process(itemData);
        }
        return itemData;
    }

    protected ItemData reverseItemMapFromHash(UserSession session, ItemData data) {
        if (data == null) {
            return null;
        }
        if (data.getTag() == null || data.getTag().isEmpty() || !data.getTag().containsKey((Object)"TOVBHash")) {
            return data;
        }
        String identifier = this.itemIdentifierToMappedIdentifier.getHashed().get(data.getTag().getInt("TOVBHash"));
        if (identifier == null) {
            return data;
        }
        ItemDefinition mapped = session.get(BaseItemRemappingStorage.class).getDefinition(identifier);
        if (mapped == null || mapped == data.getDefinition()) {
            return data;
        }
        NbtMapBuilder tagBuilder = data.getTag().toBuilder();
        if (data.getTag().containsKey((Object)"display")) {
            NbtMap display = data.getTag().getCompound("display");
            NbtMapBuilder displayNbt = display.toBuilder();
            if (display.containsKey((Object)"Lore")) {
                ArrayList lore = new ArrayList(display.getList("Lore", NbtType.STRING));
                if (lore.size() == 1) {
                    displayNbt.remove((Object)"Lore");
                } else {
                    String lore1 = "\u00a7r\u00a77Item mapped from: " + mapped.getIdentifier() + " (" + data.getTag().getInt("TOVBHash") + ").";
                    lore.remove(lore1);
                    displayNbt.putList("Lore", NbtType.STRING, lore);
                }
            }
            if (!displayNbt.isEmpty()) {
                tagBuilder.put("display", (Object)displayNbt.build());
            } else {
                tagBuilder.remove((Object)"display");
            }
        }
        tagBuilder.remove((Object)"TOVBHash");
        return new TOVBItemData(mapped, data.getDamage(), data.getCount(), tagBuilder.build(), data.getCanPlace(), data.getCanBreak(), data.getBlockingTicks(), data.getBlockDefinition(), data.isUsingNetId(), data.getNetId());
    }

    public static interface ItemMapper {
        public TOVBItemData process(TOVBItemData var1);
    }
}

