/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.chunk.impl;

import io.netty.buffer.ByteBuf;
import org.cloudburstmc.math.vector.Vector3i;
import oxy.toviabedrock.api.chunks.ChunkSection;
import oxy.toviabedrock.api.chunks.bitarray.BitArray;
import oxy.toviabedrock.api.chunks.bitarray.BitArrayVersion;
import oxy.toviabedrock.api.chunks.bitarray.SingletonBitArray;
import oxy.toviabedrock.api.chunks.palettes.NewDataPalette;
import oxy.toviabedrock.api.chunks.palettes.OlderDataPalette;
import oxy.toviabedrock.api.dimension.BedrockDimension;
import oxy.toviabedrock.base.definitions.MappedBlockDefinition;
import oxy.toviabedrock.chunk.WorldTracker;
import oxy.toviabedrock.chunk.base.WorldReaderBase;
import oxy.toviabedrock.session.UserSession;
import oxy.toviabedrock.shaded.fastutil.ints.IntArrayList;
import oxy.toviabedrock.shaded.protocol.bedrock.data.SubChunkData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.definitions.BlockDefinition;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.ChangeDimensionPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.LevelChunkPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.StartGamePacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.SubChunkPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.UpdateBlockPacket;
import oxy.toviabedrock.shaded.protocol.common.util.VarInts;

public class WorldReader_v844
extends WorldReaderBase {
    public WorldReader_v844(UserSession session) {
        super(session);
    }

    @Override
    public void onClientbound(BedrockPacket packet) {
        UpdateBlockPacket blockPacket;
        BlockDefinition blockDefinition;
        if (packet instanceof StartGamePacket) {
            StartGamePacket startGame = (StartGamePacket)packet;
            this.session.get(WorldTracker.class).setDimension(BedrockDimension.dimensionFromId(startGame.getDimensionId()));
        }
        if (packet instanceof ChangeDimensionPacket) {
            ChangeDimensionPacket dimensionPacket = (ChangeDimensionPacket)packet;
            WorldTracker tracker = this.session.get(WorldTracker.class);
            tracker.setDimension(BedrockDimension.dimensionFromId(dimensionPacket.getDimension()));
            tracker.clear();
        }
        if (packet instanceof LevelChunkPacket) {
            LevelChunkPacket levelPacket = (LevelChunkPacket)packet;
            this.readLevelChunk(levelPacket);
        }
        if (packet instanceof SubChunkPacket) {
            SubChunkPacket subChunkPacket = (SubChunkPacket)packet;
            this.readSubChunk(subChunkPacket);
        }
        if (packet instanceof UpdateBlockPacket && (blockDefinition = (blockPacket = (UpdateBlockPacket)packet).getDefinition()) instanceof MappedBlockDefinition) {
            MappedBlockDefinition mapped = (MappedBlockDefinition)blockDefinition;
            this.session.get(WorldTracker.class).set(blockPacket.getBlockPosition().getX(), blockPacket.getBlockPosition().getY(), blockPacket.getBlockPosition().getZ(), blockPacket.getDataLayer(), mapped.oldId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readLevelChunk(LevelChunkPacket packet) {
        int subChunksCount = packet.getSubChunksLength();
        if (subChunksCount < -2 || packet.getDimension() < 0 || packet.getDimension() > 2) {
            return;
        }
        WorldTracker tracker = this.session.get(WorldTracker.class);
        ChunkSection[] sections = new ChunkSection[tracker.getDimension().getHeight() >> 4];
        ByteBuf buffer = packet.getData().retainedDuplicate();
        try {
            block10: for (int i = 0; i < subChunksCount; ++i) {
                byte version = buffer.readByte();
                switch (version) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        sections[i] = new ChunkSection(new OlderDataPalette[]{this.readV0Section(buffer)});
                        continue block10;
                    }
                    case 1: {
                        sections[i] = new ChunkSection(new NewDataPalette[]{this.readBlockPalette(buffer)});
                        continue block10;
                    }
                    case 8: 
                    case 9: {
                        sections[i] = new ChunkSection(this.readV9_8Section(version, buffer));
                    }
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            buffer.release();
        }
        tracker.put(packet.getChunkX(), packet.getChunkZ(), sections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSubChunk(SubChunkPacket packet) {
        WorldTracker tracker = this.session.get(WorldTracker.class);
        for (SubChunkData chunkData : packet.getSubChunks()) {
            Vector3i position = packet.getCenterPosition().add(chunkData.getPosition());
            ChunkSection[] chunk = tracker.get(position.getX(), position.getZ());
            if (chunk == null) continue;
            ChunkSection section = chunk[position.getY() + Math.abs(tracker.getDimension().getMinY() >> 4)];
            ByteBuf buffer = chunkData.getData().retainedDuplicate();
            try {
                ChunkSection readSection = null;
                byte version = buffer.readByte();
                switch (version) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        readSection = new ChunkSection(new OlderDataPalette[]{this.readV0Section(buffer)});
                        break;
                    }
                    case 1: {
                        readSection = new ChunkSection(new NewDataPalette[]{this.readBlockPalette(buffer)});
                        break;
                    }
                    case 8: 
                    case 9: {
                        readSection = new ChunkSection(this.readV9_8Section(version, buffer));
                    }
                }
                if (readSection == null) continue;
                if (section == null) {
                    chunk[position.getY() + Math.abs((int)(tracker.getDimension().getMinY() >> 4))] = readSection;
                    continue;
                }
                if (!section.getDataPalettes().isEmpty()) continue;
                section.getDataPalettes().addAll(readSection.getDataPalettes());
            }
            catch (Exception exception) {}
            continue;
            finally {
                buffer.release();
            }
        }
    }

    private OlderDataPalette readV0Section(ByteBuf buffer) {
        OlderDataPalette palette = new OlderDataPalette();
        buffer.readBytes(palette.getBlocks());
        buffer.readBytes(palette.getData().getHandle());
        return palette;
    }

    private NewDataPalette[] readV9_8Section(int version, ByteBuf buffer) {
        int layers = buffer.readUnsignedByte();
        if (version == 9) {
            buffer.readUnsignedByte();
        }
        NewDataPalette[] palettes = new NewDataPalette[layers];
        for (int layer = 0; layer < layers; ++layer) {
            palettes[layer] = this.readBlockPalette(buffer);
        }
        return palettes;
    }

    private NewDataPalette readBlockPalette(ByteBuf buffer) {
        short header = buffer.readUnsignedByte();
        int bitArrayVersion = header >> 1;
        if (bitArrayVersion == 127) {
            return null;
        }
        BitArray bitArray = bitArrayVersion == 0 ? BitArrayVersion.get(bitArrayVersion, true).createArray(4096, null) : BitArrayVersion.get(bitArrayVersion, true).createArray(4096);
        if (!(bitArray instanceof SingletonBitArray)) {
            for (int i = 0; i < bitArray.getWords().length; ++i) {
                bitArray.getWords()[i] = buffer.readIntLE();
            }
        }
        int size = bitArray instanceof SingletonBitArray ? 1 : VarInts.readInt(buffer);
        IntArrayList palette = new IntArrayList(size);
        for (int i = 0; i < size; ++i) {
            palette.add(VarInts.readInt(buffer));
        }
        return new NewDataPalette(bitArray, palette);
    }
}

