/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.mappers.v766;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudburstmc.nbt.NbtMap;
import oxy.toviabedrock.base.ProtocolToProtocol;
import oxy.toviabedrock.base.mappers.BaseItemMapper;
import oxy.toviabedrock.mappers.v844.ItemMapper_v844;
import oxy.toviabedrock.shaded.gson.JsonArray;
import oxy.toviabedrock.shaded.gson.JsonElement;
import oxy.toviabedrock.shaded.gson.JsonObject;
import oxy.toviabedrock.shaded.gson.JsonParser;
import oxy.toviabedrock.shaded.protocol.bedrock.data.definitions.ItemDefinition;
import oxy.toviabedrock.shaded.protocol.bedrock.data.definitions.SimpleItemDefinition;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.ItemVersion;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.ItemComponentPacket;

public class ItemMapper_v766
extends ItemMapper_v844 {
    protected List<String> vanillaItemIdentifiers;

    public ItemMapper_v766(ProtocolToProtocol translator) {
        super(translator);
    }

    protected void loadVanillaIdentifiersFromFile(String name) {
        if (this.vanillaItemIdentifiers == null) {
            this.vanillaItemIdentifiers = new ArrayList<String>();
        }
        try {
            String jsonString = new String(Objects.requireNonNull(BaseItemMapper.class.getResourceAsStream("/items/vanilla/" + name)).readAllBytes());
            JsonObject object = JsonParser.parseString(jsonString).getAsJsonObject();
            JsonArray items = object.getAsJsonArray("items");
            for (JsonElement identifier : items) {
                this.vanillaItemIdentifiers.add(identifier.getAsString());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected void registerProtocol() {
        super.registerProtocol();
        this.registerClientbound(ItemComponentPacket.class, wrapped -> {
            ItemComponentPacket packet = (ItemComponentPacket)wrapped.getPacket();
            packet.getItems().removeIf(definition -> this.vanillaItemIdentifiers.contains(definition.getIdentifier()));
            for (int i = 0; i < packet.getItems().size(); ++i) {
                ItemDefinition definition2 = packet.getItems().get(i);
                packet.getItems().set(i, new SimpleItemDefinition(definition2.getIdentifier(), definition2.getRuntimeId(), ItemVersion.DATA_DRIVEN, true, NbtMap.EMPTY));
            }
        });
    }
}

