/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.mappers.v844;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import oxy.toviabedrock.api.chunks.bitarray.BitArrayVersion;
import oxy.toviabedrock.base.ProtocolToProtocol;
import oxy.toviabedrock.base.definitions.UnknownBlockDefinition;
import oxy.toviabedrock.base.mappers.BaseBlockMapper;
import oxy.toviabedrock.base.mappers.storage.BaseItemRemappingStorage;
import oxy.toviabedrock.chunk.WorldTracker;
import oxy.toviabedrock.session.UserSession;
import oxy.toviabedrock.shaded.protocol.bedrock.data.LevelEvent;
import oxy.toviabedrock.shaded.protocol.bedrock.data.LevelEventType;
import oxy.toviabedrock.shaded.protocol.bedrock.data.SubChunkData;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.ClientCacheStatusPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.InventoryTransactionPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.LevelChunkPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.LevelEventPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.SubChunkPacket;
import oxy.toviabedrock.shaded.protocol.common.util.VarInts;
import oxy.toviabedrock.utils.MathUtils;

public class BlockMapper_v844
extends BaseBlockMapper {
    private final List<LevelEventType> BLOCK_PARTICLE_EVENTS = List.of(LevelEvent.PARTICLE_BREAK_BLOCK_DOWN, LevelEvent.PARTICLE_BREAK_BLOCK_UP, LevelEvent.PARTICLE_BREAK_BLOCK_NORTH, LevelEvent.PARTICLE_BREAK_BLOCK_SOUTH, LevelEvent.PARTICLE_BREAK_BLOCK_WEST, LevelEvent.PARTICLE_BREAK_BLOCK_EAST, LevelEvent.PARTICLE_DESTROY_BLOCK, LevelEvent.PARTICLE_DESTROY_BLOCK_NO_SOUND, LevelEvent.PARTICLE_BLOCK_EXPLOSION, LevelEvent.PARTICLE_DENY_BLOCK, LevelEvent.PARTICLE_CRACK_BLOCK);

    public BlockMapper_v844(ProtocolToProtocol translator) {
        super(translator);
    }

    @Override
    public void init(UserSession session) {
        session.put(new BaseItemRemappingStorage(session));
    }

    @Override
    protected void registerProtocol() {
        super.registerProtocol();
        this.registerServerbound(InventoryTransactionPacket.class, wrapped -> {
            int newId;
            InventoryTransactionPacket packet = (InventoryTransactionPacket)wrapped.getPacket();
            if (packet.getBlockDefinition() != null && (newId = wrapped.session().get(WorldTracker.class).get(packet.getBlockPosition().getX(), packet.getBlockPosition().getY(), packet.getBlockPosition().getZ(), 0)) != -1) {
                packet.setBlockDefinition(new UnknownBlockDefinition(newId));
            }
        });
        this.registerClientbound(LevelEventPacket.class, wrapped -> {
            LevelEventPacket packet = (LevelEventPacket)wrapped.getPacket();
            if (this.BLOCK_PARTICLE_EVENTS.contains(packet.getType())) {
                packet.setData(this.mapBlockIdOrHashedId(wrapped.session(), packet.getData()));
            }
        });
        this.registerServerbound(ClientCacheStatusPacket.class, wrapped -> {
            ClientCacheStatusPacket packet = (ClientCacheStatusPacket)wrapped.getPacket();
            packet.setSupported(false);
        });
        this.registerClientbound(LevelChunkPacket.class, wrapped -> {
            LevelChunkPacket packet = (LevelChunkPacket)wrapped.getPacket();
            int subChunksCount = packet.getSubChunksLength();
            if (subChunksCount < -2 || packet.getDimension() < 0 || packet.getDimension() > 2) {
                wrapped.cancel();
                return;
            }
            ByteBuf newBuffer = ByteBufAllocator.DEFAULT.ioBuffer(packet.getData().capacity());
            ByteBuf buffer = Unpooled.wrappedBuffer((ByteBuf)packet.getData());
            try {
                for (int i = 0; i < subChunksCount; ++i) {
                    this.mapBlockPaletteInChunkSection(wrapped.session(), buffer, newBuffer);
                }
                newBuffer.writeBytes(buffer);
                byte[] payload = new byte[newBuffer.readableBytes()];
                newBuffer.readBytes(payload);
                LevelChunkPacket levelChunkPacket = new LevelChunkPacket();
                levelChunkPacket.setChunkX(packet.getChunkX());
                levelChunkPacket.setChunkZ(packet.getChunkZ());
                levelChunkPacket.setDimension(packet.getDimension());
                levelChunkPacket.setRequestSubChunks(packet.isRequestSubChunks());
                levelChunkPacket.setCachingEnabled(packet.isCachingEnabled());
                levelChunkPacket.setSubChunkLimit(packet.getSubChunkLimit());
                levelChunkPacket.setSubChunksLength(packet.getSubChunksLength());
                levelChunkPacket.getBlobIds().addAll(packet.getBlobIds());
                levelChunkPacket.setData(Unpooled.wrappedBuffer((byte[])payload));
                wrapped.setPacket(levelChunkPacket);
            }
            catch (Exception ignored) {
                wrapped.cancel();
            }
            finally {
                newBuffer.release();
            }
        });
        this.registerClientbound(SubChunkPacket.class, wrapped -> {
            SubChunkPacket packet = (SubChunkPacket)wrapped.getPacket();
            ArrayList<SubChunkData> subChunks = new ArrayList<SubChunkData>();
            for (SubChunkData chunkData : packet.getSubChunks()) {
                ByteBuf buffer = Unpooled.wrappedBuffer((ByteBuf)chunkData.getData());
                ByteBuf newBuffer = ByteBufAllocator.DEFAULT.ioBuffer(buffer.capacity());
                try {
                    this.mapBlockPaletteInChunkSection(wrapped.session(), buffer, newBuffer);
                    newBuffer.writeBytes(buffer);
                    byte[] payload = new byte[newBuffer.readableBytes()];
                    newBuffer.readBytes(payload);
                    SubChunkData data = new SubChunkData();
                    data.setPosition(chunkData.getPosition());
                    data.setData(Unpooled.wrappedBuffer((byte[])payload));
                    data.setResult(chunkData.getResult());
                    data.setHeightMapType(chunkData.getHeightMapType());
                    data.setHeightMapData(chunkData.getHeightMapData() == null ? null : Unpooled.wrappedBuffer((ByteBuf)chunkData.getHeightMapData().copy()));
                    data.setRenderHeightMapType(chunkData.getRenderHeightMapType());
                    data.setRenderHeightMapData(chunkData.getRenderHeightMapData() == null ? null : Unpooled.wrappedBuffer((ByteBuf)chunkData.getRenderHeightMapData().copy()));
                    data.setCacheEnabled(chunkData.isCacheEnabled());
                    data.setBlobId(chunkData.getBlobId());
                    subChunks.add(data);
                }
                catch (Exception ignored) {
                    wrapped.cancel();
                    return;
                }
                finally {
                    newBuffer.release();
                }
            }
            SubChunkPacket subChunkPacket = new SubChunkPacket();
            subChunkPacket.setCacheEnabled(packet.isCacheEnabled());
            subChunkPacket.setDimension(packet.getDimension());
            subChunkPacket.setCenterPosition(packet.getCenterPosition());
            subChunkPacket.setSubChunks(subChunks);
            wrapped.setPacket(subChunkPacket);
        });
    }

    private void mapBlockPaletteInChunkSection(UserSession session, ByteBuf buffer, ByteBuf newBuffer) {
        byte version = buffer.readByte();
        newBuffer.writeByte((int)version);
        switch (version) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.mapBlockPaletteV0(session, buffer, newBuffer);
                break;
            }
            case 1: {
                this.mapBlockPalette(session, buffer, newBuffer);
                break;
            }
            case 8: 
            case 9: {
                this.mapBlockPaletteV9_8(session, version, buffer, newBuffer);
            }
        }
    }

    private void mapBlockPaletteV0(UserSession session, ByteBuf buffer, ByteBuf newBuffer) {
        byte[] blockArray = new byte[4096];
        byte[] blockData = new byte[2048];
        buffer.readBytes(blockArray);
        buffer.readBytes(blockData);
        for (int i = 0; i < blockArray.length; ++i) {
            byte blockDataIndex = blockData[i / 2];
            byte value = i % 2 == 0 ? (byte)(blockDataIndex & 0xF) : (byte)(blockDataIndex >> 4 & 0xF);
            int oldId = (blockArray[i] & 0xFF) << 4 | value;
            int newId = this.mapBlockIdOrHashedId(session, oldId);
            blockArray[i] = (byte)(newId >> 4);
            blockData[i] = (i /= 2) % 2 == 0 ? (byte)(blockData[i] & 0xF0 | newId & 0xF) : (byte)(blockData[i] & 0xF | (newId & 0xF) << 4);
        }
        newBuffer.writeBytes(blockArray);
        newBuffer.writeBytes(blockData);
    }

    private void mapBlockPaletteV9_8(UserSession session, int version, ByteBuf buffer, ByteBuf newBuffer) {
        int layers = buffer.readUnsignedByte();
        newBuffer.writeByte(layers);
        if (version == 9) {
            newBuffer.writeByte((int)buffer.readUnsignedByte());
        }
        for (int layer = 0; layer < layers; ++layer) {
            this.mapBlockPalette(session, buffer, newBuffer);
        }
    }

    private void mapBlockPalette(UserSession session, ByteBuf buffer, ByteBuf newBuffer) {
        int size;
        short header = buffer.readUnsignedByte();
        newBuffer.writeByte((int)header);
        int bitArrayVersion = header >> 1;
        if (bitArrayVersion == 127) {
            return;
        }
        BitArrayVersion bitVersion = BitArrayVersion.get(bitArrayVersion, true);
        int wordCount = MathUtils.ceil(4096.0f / (float)BitArrayVersion.values()[bitVersion.ordinal()].entriesPerWord);
        if (bitVersion != BitArrayVersion.V0) {
            for (int word = 0; word < wordCount; ++word) {
                newBuffer.writeIntLE(buffer.readIntLE());
            }
        }
        if (bitVersion == BitArrayVersion.V0) {
            size = 1;
        } else {
            size = VarInts.readInt(buffer);
            VarInts.writeInt(newBuffer, size);
        }
        for (int paletteIndex = 0; paletteIndex < size; ++paletteIndex) {
            VarInts.writeInt(newBuffer, this.mapBlockIdOrHashedId(session, VarInts.readInt(buffer)));
        }
    }
}

