/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.mappers.v844;

import oxy.toviabedrock.base.ProtocolToProtocol;
import oxy.toviabedrock.base.mappers.BaseItemMapper;
import oxy.toviabedrock.base.mappers.storage.BaseItemRemappingStorage;
import oxy.toviabedrock.shaded.protocol.bedrock.data.definitions.ItemDefinition;
import oxy.toviabedrock.shaded.protocol.bedrock.data.definitions.SimpleItemDefinition;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.CreativeItemData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.ItemData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.CraftingDataType;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.recipe.RecipeData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.recipe.ShapedRecipeData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.recipe.ShapelessRecipeData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.descriptor.DefaultDescriptor;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.descriptor.ItemDescriptor;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.CraftingDataPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.CreativeContentPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.ItemComponentPacket;

public class ItemMapper_v844
extends BaseItemMapper {
    public ItemMapper_v844(ProtocolToProtocol translator) {
        super(translator);
    }

    @Override
    protected void registerProtocol() {
        super.registerProtocol();
        this.registerClientbound(ItemComponentPacket.class, wrapped -> {
            ItemComponentPacket packet = (ItemComponentPacket)wrapped.getPacket();
            for (int i = 0; i < packet.getItems().size(); ++i) {
                ItemDefinition definition = packet.getItems().get(i);
                String identifier = (String)this.identifierToIdentifier.get(definition.getIdentifier());
                if (identifier != null) {
                    packet.getItems().set(i, new SimpleItemDefinition(identifier, definition.getRuntimeId(), definition.getVersion(), definition.isComponentBased(), definition.getComponentData()));
                }
                wrapped.session().get(BaseItemRemappingStorage.class).put(definition.getIdentifier(), definition);
            }
        });
        this.registerClientbound(CreativeContentPacket.class, wrapped -> {
            CreativeContentPacket packet = (CreativeContentPacket)wrapped.getPacket();
            for (int i = 0; i < packet.getContents().size(); ++i) {
                CreativeItemData creative = packet.getContents().get(i);
                ItemData itemData = creative.getItem();
                ItemData mapped = this.mapItemAndApplyHash(wrapped.session(), itemData);
                if (mapped == itemData) continue;
                packet.getContents().set(i, new CreativeItemData(mapped, creative.getNetId(), creative.getGroupId()));
            }
        });
        this.registerClientbound(CraftingDataPacket.class, wrapped -> {
            CraftingDataPacket packet = (CraftingDataPacket)wrapped.getPacket();
            for (RecipeData data : packet.getCraftingData()) {
                ItemDefinition mapped;
                DefaultDescriptor descriptor;
                ItemDescriptor patt0$temp;
                ItemDescriptorWithCount ingredient;
                int i;
                if (data.getType() != CraftingDataType.SHAPED && data.getType() != CraftingDataType.SHAPELESS) continue;
                if (data instanceof ShapedRecipeData) {
                    ShapedRecipeData shaped = (ShapedRecipeData)data;
                    shaped.getResults().replaceAll(itemData -> this.mapItemAndApplyHash(wrapped.session(), (ItemData)itemData));
                    for (i = 0; i < shaped.getIngredients().size(); ++i) {
                        ingredient = shaped.getIngredients().get(i);
                        patt0$temp = ingredient.getDescriptor();
                        if (!(patt0$temp instanceof DefaultDescriptor) || (descriptor = (DefaultDescriptor)patt0$temp).getItemId() == ItemData.AIR.getDefinition() || (mapped = this.mapItemDefinitionWithOldIdentifier(wrapped.session(), descriptor.getItemId())) == null) continue;
                        shaped.getIngredients().set(i, new ItemDescriptorWithCount(new DefaultDescriptor(mapped, descriptor.getAuxValue()), ingredient.getCount()));
                    }
                    shaped.getResults().replaceAll(itemData -> this.mapItemAndApplyHash(wrapped.session(), (ItemData)itemData));
                    continue;
                }
                if (!(data instanceof ShapelessRecipeData)) continue;
                ShapelessRecipeData shapeless = (ShapelessRecipeData)data;
                shapeless.getResults().replaceAll(itemData -> this.mapItemAndApplyHash(wrapped.session(), (ItemData)itemData));
                for (i = 0; i < shapeless.getIngredients().size(); ++i) {
                    ingredient = shapeless.getIngredients().get(i);
                    patt0$temp = ingredient.getDescriptor();
                    if (!(patt0$temp instanceof DefaultDescriptor) || (descriptor = (DefaultDescriptor)patt0$temp).getItemId() == ItemData.AIR.getDefinition() || (mapped = this.mapItemDefinitionWithOldIdentifier(wrapped.session(), descriptor.getItemId())) == null) continue;
                    shapeless.getIngredients().set(i, new ItemDescriptorWithCount(new DefaultDescriptor(mapped, descriptor.getAuxValue()), ingredient.getCount()));
                }
            }
        });
    }
}

