/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.protocols.v274to261;

import java.util.Arrays;
import org.cloudburstmc.math.vector.Vector3f;
import oxy.toviabedrock.base.ProtocolToProtocol;
import oxy.toviabedrock.codec.v261.Bedrock_v261;
import oxy.toviabedrock.codec.v274.Bedrock_v274;
import oxy.toviabedrock.protocols.v274to261.storage.EntityTracker_v261;
import oxy.toviabedrock.session.UserSession;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.AddEntityPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.AddItemEntityPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.AddPaintingPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.AddPlayerPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacketType;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.MoveEntityDeltaPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.MovePlayerPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.RemoveEntityPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.UpdateBlockSyncedPacket;

public class Protocol274to261
extends ProtocolToProtocol {
    public Protocol274to261() {
        super(Bedrock_v274.CODEC, Bedrock_v261.CODEC);
    }

    @Override
    public void init(UserSession session) {
        session.put(new EntityTracker_v261(session));
    }

    @Override
    protected void registerProtocol() {
        Arrays.stream(BedrockPacketType.values()).forEach(this::mapDirectlyServerbound);
        Arrays.stream(BedrockPacketType.values()).forEach(this::mapDirectlyClientbound);
        this.ignoreClientbound(UpdateBlockSyncedPacket.class);
        this.registerClientbound(RemoveEntityPacket.class, wrapped -> {
            RemoveEntityPacket packet = (RemoveEntityPacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v261.class).remove(packet.getUniqueEntityId());
        });
        this.registerClientbound(AddPaintingPacket.class, wrapped -> {
            AddPaintingPacket packet = (AddPaintingPacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v261.class).cache(packet.getRuntimeEntityId(), packet.getUniqueEntityId(), packet.getPosition(), Vector3f.ZERO);
        });
        this.registerClientbound(AddItemEntityPacket.class, wrapped -> {
            AddItemEntityPacket packet = (AddItemEntityPacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v261.class).cache(packet.getRuntimeEntityId(), packet.getUniqueEntityId(), packet.getPosition(), Vector3f.ZERO);
        });
        this.registerClientbound(AddPlayerPacket.class, wrapped -> {
            AddPlayerPacket packet = (AddPlayerPacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v261.class).cache(packet.getRuntimeEntityId(), packet.getUniqueEntityId(), packet.getPosition(), packet.getRotation());
        });
        this.registerClientbound(AddEntityPacket.class, wrapped -> {
            AddEntityPacket packet = (AddEntityPacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v261.class).cache(packet.getRuntimeEntityId(), packet.getUniqueEntityId(), packet.getPosition(), Vector3f.from((float)packet.getRotation().getX(), (float)packet.getRotation().getY(), (float)packet.getRotation().getY()));
        });
        this.registerClientbound(MovePlayerPacket.class, wrapped -> {
            MovePlayerPacket packet = (MovePlayerPacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v261.class).moveAbsolute(packet.getRuntimeEntityId(), packet.getPosition(), packet.getRotation());
        });
        this.registerClientbound(MoveEntityAbsolutePacket.class, wrapped -> {
            MoveEntityAbsolutePacket packet = (MoveEntityAbsolutePacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v261.class).moveAbsolute(packet.getRuntimeEntityId(), packet.getPosition(), packet.getRotation());
        });
        this.registerClientbound(MoveEntityDeltaPacket.class, wrapped -> {
            EntityTracker_v261 entityTracker = wrapped.session().get(EntityTracker_v261.class);
            MoveEntityDeltaPacket packet = (MoveEntityDeltaPacket)wrapped.getPacket();
            entityTracker.moveRelative(packet.getRuntimeEntityId(), packet);
            EntityTracker_v261.EntityCache entity = entityTracker.getEntity(packet.getRuntimeEntityId());
            if (entity == null) {
                return;
            }
            MoveEntityAbsolutePacket absolutePacket = new MoveEntityAbsolutePacket();
            absolutePacket.setRuntimeEntityId(packet.getRuntimeEntityId());
            absolutePacket.setPosition(entity.getPosition());
            absolutePacket.setRotation(entity.getRotation());
            absolutePacket.setOnGround(packet.getFlags().contains((Object)MoveEntityDeltaPacket.Flag.ON_GROUND));
            absolutePacket.setTeleported(packet.getFlags().contains((Object)MoveEntityDeltaPacket.Flag.TELEPORTING));
            absolutePacket.setForceMove(packet.getFlags().contains((Object)MoveEntityDeltaPacket.Flag.FORCE_MOVE_LOCAL_ENTITY));
            wrapped.setPacket(absolutePacket);
        });
    }
}

