/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.protocols.v274to261.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cloudburstmc.math.vector.Vector3f;
import oxy.toviabedrock.session.UserSession;
import oxy.toviabedrock.session.storage.UserStorage;
import oxy.toviabedrock.shaded.lombok.Generated;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.MoveEntityDeltaPacket;

public class EntityTracker_v261
extends UserStorage {
    private final Map<Long, Long> uniqueIdToRuntimeId = new HashMap<Long, Long>();
    private final Map<Long, EntityCache> entities = new ConcurrentHashMap<Long, EntityCache>();

    public EntityTracker_v261(UserSession session) {
        super(session);
    }

    public void cache(long runtimeId, long uniqueId, Vector3f position, Vector3f rotation) {
        this.entities.put(runtimeId, new EntityCache(position, rotation));
        this.uniqueIdToRuntimeId.put(uniqueId, runtimeId);
    }

    public void remove(long entityId) {
        this.entities.remove(this.uniqueIdToRuntimeId.remove(entityId));
    }

    public void moveRelative(long entityId, MoveEntityDeltaPacket delta) {
        EntityCache entity = this.entities.get(entityId);
        if (entity == null) {
            return;
        }
        float posX = delta.getFlags().contains((Object)MoveEntityDeltaPacket.Flag.HAS_X) ? entity.position.getX() : this.translateValue(entity.position.getX(), delta.getDeltaX());
        float posY = delta.getFlags().contains((Object)MoveEntityDeltaPacket.Flag.HAS_Y) ? entity.position.getY() : this.translateValue(entity.position.getY(), delta.getDeltaY());
        float posZ = delta.getFlags().contains((Object)MoveEntityDeltaPacket.Flag.HAS_Z) ? entity.position.getZ() : this.translateValue(entity.position.getZ(), delta.getDeltaZ());
        float pitch = delta.getFlags().contains((Object)MoveEntityDeltaPacket.Flag.HAS_PITCH) ? delta.getPitch() : entity.rotation.getX();
        float yaw = delta.getFlags().contains((Object)MoveEntityDeltaPacket.Flag.HAS_YAW) ? delta.getYaw() : entity.rotation.getY();
        float headYaw = delta.getFlags().contains((Object)MoveEntityDeltaPacket.Flag.HAS_HEAD_YAW) ? delta.getHeadYaw() : entity.rotation.getZ();
        entity.setPosition(Vector3f.from((float)posX, (float)posY, (float)posZ));
        entity.setRotation(Vector3f.from((float)pitch, (float)yaw, (float)headYaw));
    }

    public void moveAbsolute(long entityId, Vector3f position, Vector3f rotation) {
        EntityCache entity = this.entities.get(entityId);
        if (this.entities.get(entityId) == null) {
            return;
        }
        entity.setPosition(position);
        entity.setRotation(rotation);
    }

    public EntityCache getEntity(long entityId) {
        return this.entities.get(entityId);
    }

    private float translateValue(float value, int delta) {
        return Float.intBitsToFloat(delta + Float.floatToIntBits((float)Math.round((double)value * 100.0) / 100.0f));
    }

    public static class EntityCache {
        private Vector3f position;
        private Vector3f rotation;

        @Generated
        public EntityCache(Vector3f position, Vector3f rotation) {
            this.position = position;
            this.rotation = rotation;
        }

        @Generated
        public Vector3f getPosition() {
            return this.position;
        }

        @Generated
        public Vector3f getRotation() {
            return this.rotation;
        }

        @Generated
        public void setPosition(Vector3f position) {
            this.position = position;
        }

        @Generated
        public void setRotation(Vector3f rotation) {
            this.rotation = rotation;
        }
    }
}

