/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.protocols.v766to748;

import java.util.Arrays;
import org.cloudburstmc.math.vector.Vector2f;
import oxy.toviabedrock.base.ProtocolToProtocol;
import oxy.toviabedrock.base.mappers.BaseEntityMapper;
import oxy.toviabedrock.mappers.v766.ItemMapper_v766;
import oxy.toviabedrock.mappers.v844.BlockMapper_v844;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v748.Bedrock_v748;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v766.Bedrock_v766;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacketType;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.CameraAimAssistPresetsPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.PlayerAuthInputPacket;
import oxy.toviabedrock.utils.MathUtils;

public class Protocol766to748
extends ProtocolToProtocol {
    public Protocol766to748() {
        super(Bedrock_v766.CODEC, Bedrock_v748.CODEC);
    }

    @Override
    public void initMappers() {
        this.mappers.add(new BlockMapper_v844(this){

            @Override
            protected void initBlockMappings() {
                this.loadBlockMappingFromFile("v766to748/blockIds_v766to748.json");
                this.loadHashedBlockMappingFromFile("v766to748/blockIds_v766to748_hashed.json");
            }
        });
        this.mappers.add(new ItemMapper_v766(this){

            @Override
            protected void initItemMappings() {
                this.loadItemMappingsFromFile("itemIdentifiers_v766to748.json");
                this.loadVanillaIdentifiersFromFile("vanilla_items_v748.json");
            }
        });
        this.mappers.add(new BaseEntityMapper(this){

            @Override
            protected void initEntityMappings() {
                this.identifierToMapped.put("minecraft:creaking", new BaseEntityMapper.MappedEntity("minecraft:armor_stand", true));
            }
        });
        super.initMappers();
    }

    @Override
    protected void registerProtocol() {
        Arrays.stream(BedrockPacketType.values()).forEach(this::mapDirectlyServerbound);
        Arrays.stream(BedrockPacketType.values()).forEach(this::mapDirectlyClientbound);
        this.ignoreClientbound(CameraAimAssistPresetsPacket.class);
        this.registerServerbound(PlayerAuthInputPacket.class, wrapped -> {
            PlayerAuthInputPacket packet = (PlayerAuthInputPacket)wrapped.getPacket();
            if (packet.getAnalogMoveVector().lengthSquared() > 0.0f) {
                packet.setRawMoveVector(packet.getAnalogMoveVector());
            } else {
                packet.setRawMoveVector(Vector2f.from((float)MathUtils.sign(packet.getMotion().getX()), (float)MathUtils.sign(packet.getMotion().getY())));
            }
        });
    }
}

