/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.protocols.v786to776;

import java.util.Arrays;
import java.util.EnumSet;
import oxy.toviabedrock.base.ProtocolToProtocol;
import oxy.toviabedrock.mappers.v844.BlockMapper_v844;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v776.Bedrock_v776;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v786.Bedrock_v786;
import oxy.toviabedrock.shaded.protocol.bedrock.data.ExperimentData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.entity.EntityDataMap;
import oxy.toviabedrock.shaded.protocol.bedrock.data.entity.EntityFlag;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.AddEntityPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacketType;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.LevelSoundEvent1Packet;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.LevelSoundEvent2Packet;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.PlayerVideoCapturePacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.ResourcePackStackPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.SetEntityDataPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.StartGamePacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.UpdateClientOptionsPacket;

public class Protocol786to776
extends ProtocolToProtocol {
    public Protocol786to776() {
        super(Bedrock_v786.CODEC, Bedrock_v776.CODEC);
    }

    @Override
    public void initMappers() {
        this.mappers.add(new BlockMapper_v844(this){

            @Override
            protected void initBlockMappings() {
                this.loadBlockMappingFromFile("v786to776/blockIds_v786to776.json");
                this.loadHashedBlockMappingFromFile("v786to776/blockIds_v786to776_hashed.json");
            }
        });
        super.initMappers();
    }

    @Override
    protected void registerProtocol() {
        Arrays.stream(BedrockPacketType.values()).forEach(this::mapDirectlyServerbound);
        Arrays.stream(BedrockPacketType.values()).forEach(this::mapDirectlyClientbound);
        this.ignoreClientbound(UpdateClientOptionsPacket.class);
        this.ignoreClientbound(PlayerVideoCapturePacket.class);
        this.ignoreServerbound(LevelSoundEvent1Packet.class);
        this.ignoreServerbound(LevelSoundEvent2Packet.class);
        this.registerClientbound(StartGamePacket.class, wrapped -> {
            StartGamePacket packet = (StartGamePacket)wrapped.getPacket();
            packet.getExperiments().clear();
            packet.getExperiments().add(new ExperimentData("y_2025_drop_1", true));
        });
        this.registerClientbound(ResourcePackStackPacket.class, wrapped -> {
            ResourcePackStackPacket packet = (ResourcePackStackPacket)wrapped.getPacket();
            packet.getExperiments().clear();
            packet.getExperiments().add(new ExperimentData("y_2025_drop_1", true));
        });
        this.registerClientbound(AddEntityPacket.class, wrapped -> this.cleanMetadata(((AddEntityPacket)wrapped.getPacket()).getMetadata()));
        this.registerClientbound(SetEntityDataPacket.class, wrapped -> this.cleanMetadata(((SetEntityDataPacket)wrapped.getPacket()).getMetadata()));
    }

    private void cleanMetadata(EntityDataMap metadata) {
        if (metadata == null) {
            return;
        }
        EnumSet<EntityFlag> flags = metadata.getFlags();
        if (flags != null) {
            flags.remove((Object)EntityFlag.BODY_ROTATION_AXIS_ALIGNED);
            flags.remove((Object)EntityFlag.COLLIDABLE);
            flags.remove((Object)EntityFlag.WASD_AIR_CONTROLLED);
        }
    }
}

