/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.protocols.v818to800;

import java.util.Arrays;
import java.util.EnumSet;
import oxy.toviabedrock.base.ProtocolToProtocol;
import oxy.toviabedrock.base.mappers.BaseEntityMapper;
import oxy.toviabedrock.mappers.v844.ItemMapper_v844;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v800.Bedrock_v800;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v818.Bedrock_v818;
import oxy.toviabedrock.shaded.protocol.bedrock.data.AuthoritativeMovementMode;
import oxy.toviabedrock.shaded.protocol.bedrock.data.ExperimentData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.entity.EntityDataMap;
import oxy.toviabedrock.shaded.protocol.bedrock.data.entity.EntityFlag;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.AddEntityPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacketType;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.ResourcePackStackPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.SetEntityDataPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.StartGamePacket;

public class Protocol818to800
extends ProtocolToProtocol {
    public Protocol818to800() {
        super(Bedrock_v818.CODEC, Bedrock_v800.CODEC);
    }

    @Override
    public void initMappers() {
        this.mappers.add(new ItemMapper_v844(this){

            @Override
            protected void initItemMappings() {
                this.itemIdentifierToMappedIdentifier.put("minecraft:music_disc_tears", "minecraft:music_disc_chirp");
            }
        });
        this.mappers.add(new BaseEntityMapper(this){

            @Override
            protected void initEntityMappings() {
                this.identifierToMapped.put("minecraft:happy_ghast", new BaseEntityMapper.MappedEntity("minecraft:ghast", true));
            }
        });
        super.initMappers();
    }

    @Override
    protected void registerProtocol() {
        Arrays.stream(BedrockPacketType.values()).forEach(this::mapDirectlyServerbound);
        Arrays.stream(BedrockPacketType.values()).forEach(this::mapDirectlyClientbound);
        this.registerClientbound(StartGamePacket.class, wrapped -> {
            StartGamePacket packet = (StartGamePacket)wrapped.getPacket();
            packet.setAuthoritativeMovementMode(AuthoritativeMovementMode.SERVER_WITH_REWIND);
            packet.getExperiments().clear();
            packet.getExperiments().add(new ExperimentData("experimental_graphics", true));
            packet.getExperiments().add(new ExperimentData("y_2025_drop_2", true));
            packet.getExperiments().add(new ExperimentData("locator_bar", true));
        });
        this.registerClientbound(ResourcePackStackPacket.class, wrapped -> {
            ResourcePackStackPacket packet = (ResourcePackStackPacket)wrapped.getPacket();
            packet.getExperiments().clear();
            packet.getExperiments().add(new ExperimentData("y_2025_drop_2", true));
            packet.getExperiments().add(new ExperimentData("locator_bar", true));
        });
        this.registerClientbound(AddEntityPacket.class, wrapped -> this.cleanMetadata(((AddEntityPacket)wrapped.getPacket()).getMetadata()));
        this.registerClientbound(SetEntityDataPacket.class, wrapped -> this.cleanMetadata(((SetEntityDataPacket)wrapped.getPacket()).getMetadata()));
    }

    private void cleanMetadata(EntityDataMap metadata) {
        if (metadata == null) {
            return;
        }
        EnumSet<EntityFlag> flags = metadata.getFlags();
        if (flags != null) {
            flags.remove((Object)EntityFlag.BODY_ROTATION_ALWAYS_FOLLOWS_HEAD);
        }
    }
}

