/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.protocols.v844to827;

import java.util.Arrays;
import java.util.EnumSet;
import oxy.toviabedrock.base.ProtocolToProtocol;
import oxy.toviabedrock.mappers.v844.BlockMapper_v844;
import oxy.toviabedrock.mappers.v844.ItemMapper_v844;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v827.Bedrock_v827;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v844.Bedrock_v844;
import oxy.toviabedrock.shaded.protocol.bedrock.data.ExperimentData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.entity.EntityDataMap;
import oxy.toviabedrock.shaded.protocol.bedrock.data.entity.EntityFlag;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.AddEntityPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacketType;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.ResourcePackStackPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.SetEntityDataPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.StartGamePacket;

public class Protocol844to827
extends ProtocolToProtocol {
    public Protocol844to827() {
        super(Bedrock_v844.CODEC, Bedrock_v827.CODEC);
    }

    @Override
    public void initMappers() {
        this.mappers.add(new BlockMapper_v844(this){

            @Override
            protected void initBlockMappings() {
                this.loadBlockMappingFromFile("v844to827/blockIds_v844to827.json");
                this.loadHashedBlockMappingFromFile("v844to827/blockIds_v844to827_hashed.json");
            }
        });
        this.mappers.add(new ItemMapper_v844(this){

            @Override
            protected void initItemMappings() {
                this.identifierToIdentifier.put("minecraft:iron_chain", "minecraft:chain");
                this.loadItemMappingsFromFile("itemIdentifiers_v844to827.json");
            }
        });
        super.initMappers();
    }

    @Override
    protected void registerProtocol() {
        Arrays.stream(BedrockPacketType.values()).forEach(this::mapDirectlyServerbound);
        Arrays.stream(BedrockPacketType.values()).forEach(this::mapDirectlyClientbound);
        this.registerClientbound(ResourcePackStackPacket.class, wrapped -> {
            ResourcePackStackPacket packet = (ResourcePackStackPacket)wrapped.getPacket();
            packet.getExperiments().add(new ExperimentData("y_2025_drop_3", true));
        });
        this.registerClientbound(StartGamePacket.class, wrapped -> {
            StartGamePacket packet = (StartGamePacket)wrapped.getPacket();
            packet.getExperiments().add(new ExperimentData("y_2025_drop_3", true));
        });
        this.registerClientbound(AddEntityPacket.class, wrapped -> this.cleanMetadata(((AddEntityPacket)wrapped.getPacket()).getMetadata()));
        this.registerClientbound(SetEntityDataPacket.class, wrapped -> this.cleanMetadata(((SetEntityDataPacket)wrapped.getPacket()).getMetadata()));
    }

    private void cleanMetadata(EntityDataMap metadata) {
        if (metadata == null) {
            return;
        }
        EnumSet<EntityFlag> flags = metadata.getFlags();
        if (flags != null) {
            flags.remove((Object)EntityFlag.CAN_USE_VERTICAL_MOVEMENT_ACTION);
        }
    }
}

