/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.session;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oxy.toviabedrock.ToViaBedrock;
import oxy.toviabedrock.base.ProtocolToProtocol;
import oxy.toviabedrock.base.WrappedBedrockPacket;
import oxy.toviabedrock.chunk.WorldTracker;
import oxy.toviabedrock.chunk.base.WorldReaderBase;
import oxy.toviabedrock.chunk.impl.WorldReader_v844;
import oxy.toviabedrock.session.storage.UserStorage;
import oxy.toviabedrock.session.storage.impl.GameSessionStorage;
import oxy.toviabedrock.shaded.lombok.Generated;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacket;

public abstract class UserSession {
    private final int protocolVersion;
    private final Map<Class<?>, UserStorage> storages = new HashMap();
    private final List<ProtocolToProtocol> translators;
    private final WorldReaderBase worldReader;

    protected UserSession(int protocolVersion, int serverVersion) {
        this.protocolVersion = protocolVersion;
        this.translators = ToViaBedrock.getTranslators(serverVersion, protocolVersion);
        this.put(new GameSessionStorage(this));
        this.put(new WorldTracker(this));
        this.worldReader = new WorldReader_v844(this);
    }

    public final BedrockPacket translateClientbound(BedrockPacket packet) {
        WrappedBedrockPacket wrapped = new WrappedBedrockPacket(this, packet, false);
        for (ProtocolToProtocol translator : this.translators) {
            if (translator.passthroughClientbound(wrapped)) continue;
            return null;
        }
        return wrapped.isCancelled() ? null : wrapped.getPacket();
    }

    public final BedrockPacket translateServerbound(BedrockPacket packet) {
        WrappedBedrockPacket wrapped = new WrappedBedrockPacket(this, packet, false);
        for (ProtocolToProtocol translator : this.translators) {
            if (translator.passthroughServerbound(wrapped)) continue;
            return null;
        }
        return wrapped.isCancelled() ? null : wrapped.getPacket();
    }

    public abstract void sendUpstreamPacket(BedrockPacket var1, boolean var2);

    public abstract void sendDownstreamPacket(BedrockPacket var1, boolean var2);

    public final void put(UserStorage storage) {
        this.storages.put(storage.getClass(), storage);
    }

    public final <T extends UserStorage> T get(Class<T> klass) {
        return (T)this.storages.get(klass);
    }

    @Generated
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Generated
    public List<ProtocolToProtocol> getTranslators() {
        return this.translators;
    }

    @Generated
    public WorldReaderBase getWorldReader() {
        return this.worldReader;
    }
}

