/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.StringJoiner;

public class BedrockPong {
    private String edition;
    private String motd;
    private int protocolVersion = -1;
    private String version;
    private int playerCount = -1;
    private int maximumPlayerCount = -1;
    private long serverId;
    private String subMotd;
    private String gameType;
    private boolean nintendoLimited;
    private int ipv4Port = -1;
    private int ipv6Port = -1;
    private String[] extras;

    public static BedrockPong fromRakNet(ByteBuf pong) {
        String info = pong.toString(StandardCharsets.UTF_8);
        BedrockPong bedrockPong = new BedrockPong();
        String[] infos = info.split(";");
        switch (infos.length) {
            case 0: {
                break;
            }
            default: {
                bedrockPong.extras = new String[infos.length - 12];
                System.arraycopy(infos, 12, bedrockPong.extras, 0, bedrockPong.extras.length);
            }
            case 12: {
                try {
                    bedrockPong.ipv6Port = Integer.parseInt(infos[11]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            case 11: {
                try {
                    bedrockPong.ipv4Port = Integer.parseInt(infos[10]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            case 10: {
                bedrockPong.nintendoLimited = !"1".equalsIgnoreCase(infos[9]);
            }
            case 9: {
                bedrockPong.gameType = infos[8];
            }
            case 8: {
                bedrockPong.subMotd = infos[7];
            }
            case 7: {
                try {
                    bedrockPong.serverId = Long.parseLong(infos[6]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            case 6: {
                try {
                    bedrockPong.maximumPlayerCount = Integer.parseInt(infos[5]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            case 5: {
                try {
                    bedrockPong.playerCount = Integer.parseInt(infos[4]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            case 4: {
                bedrockPong.version = infos[3];
            }
            case 3: {
                try {
                    bedrockPong.protocolVersion = Integer.parseInt(infos[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            case 2: {
                bedrockPong.motd = infos[1];
            }
            case 1: {
                bedrockPong.edition = infos[0];
            }
        }
        return bedrockPong;
    }

    public ByteBuf toByteBuf() {
        StringJoiner joiner = new StringJoiner(";", "", ";").add(this.edition).add(BedrockPong.toString(this.motd)).add(Integer.toString(this.protocolVersion)).add(BedrockPong.toString(this.version)).add(Integer.toString(this.playerCount)).add(Integer.toString(this.maximumPlayerCount)).add(Long.toUnsignedString(this.serverId)).add(BedrockPong.toString(this.subMotd)).add(BedrockPong.toString(this.gameType)).add(this.nintendoLimited ? "0" : "1").add(Integer.toString(this.ipv4Port)).add(Integer.toString(this.ipv6Port));
        if (this.extras != null) {
            for (String extra : this.extras) {
                joiner.add(extra);
            }
        }
        return Unpooled.wrappedBuffer((byte[])joiner.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static String toString(String string) {
        return string == null ? "" : string;
    }

    public String edition() {
        return this.edition;
    }

    public String motd() {
        return this.motd;
    }

    public int protocolVersion() {
        return this.protocolVersion;
    }

    public String version() {
        return this.version;
    }

    public int playerCount() {
        return this.playerCount;
    }

    public int maximumPlayerCount() {
        return this.maximumPlayerCount;
    }

    public long serverId() {
        return this.serverId;
    }

    public String subMotd() {
        return this.subMotd;
    }

    public String gameType() {
        return this.gameType;
    }

    public boolean nintendoLimited() {
        return this.nintendoLimited;
    }

    public int ipv4Port() {
        return this.ipv4Port;
    }

    public int ipv6Port() {
        return this.ipv6Port;
    }

    public String[] extras() {
        return this.extras;
    }

    public BedrockPong edition(String edition) {
        this.edition = edition;
        return this;
    }

    public BedrockPong motd(String motd) {
        this.motd = motd;
        return this;
    }

    public BedrockPong protocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    public BedrockPong version(String version) {
        this.version = version;
        return this;
    }

    public BedrockPong playerCount(int playerCount) {
        this.playerCount = playerCount;
        return this;
    }

    public BedrockPong maximumPlayerCount(int maximumPlayerCount) {
        this.maximumPlayerCount = maximumPlayerCount;
        return this;
    }

    public BedrockPong serverId(long serverId) {
        this.serverId = serverId;
        return this;
    }

    public BedrockPong subMotd(String subMotd) {
        this.subMotd = subMotd;
        return this;
    }

    public BedrockPong gameType(String gameType) {
        this.gameType = gameType;
        return this;
    }

    public BedrockPong nintendoLimited(boolean nintendoLimited) {
        this.nintendoLimited = nintendoLimited;
        return this;
    }

    public BedrockPong ipv4Port(int ipv4Port) {
        this.ipv4Port = ipv4Port;
        return this;
    }

    public BedrockPong ipv6Port(int ipv6Port) {
        this.ipv6Port = ipv6Port;
        return this;
    }

    public BedrockPong extras(String[] extras) {
        this.extras = extras;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BedrockPong)) {
            return false;
        }
        BedrockPong other = (BedrockPong)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.protocolVersion() != other.protocolVersion()) {
            return false;
        }
        if (this.playerCount() != other.playerCount()) {
            return false;
        }
        if (this.maximumPlayerCount() != other.maximumPlayerCount()) {
            return false;
        }
        if (this.serverId() != other.serverId()) {
            return false;
        }
        if (this.nintendoLimited() != other.nintendoLimited()) {
            return false;
        }
        if (this.ipv4Port() != other.ipv4Port()) {
            return false;
        }
        if (this.ipv6Port() != other.ipv6Port()) {
            return false;
        }
        String this$edition = this.edition();
        String other$edition = other.edition();
        if (this$edition == null ? other$edition != null : !this$edition.equals(other$edition)) {
            return false;
        }
        String this$motd = this.motd();
        String other$motd = other.motd();
        if (this$motd == null ? other$motd != null : !this$motd.equals(other$motd)) {
            return false;
        }
        String this$version = this.version();
        String other$version = other.version();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$subMotd = this.subMotd();
        String other$subMotd = other.subMotd();
        if (this$subMotd == null ? other$subMotd != null : !this$subMotd.equals(other$subMotd)) {
            return false;
        }
        String this$gameType = this.gameType();
        String other$gameType = other.gameType();
        if (this$gameType == null ? other$gameType != null : !this$gameType.equals(other$gameType)) {
            return false;
        }
        return Arrays.deepEquals(this.extras(), other.extras());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BedrockPong;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.protocolVersion();
        result = result * 59 + this.playerCount();
        result = result * 59 + this.maximumPlayerCount();
        long $serverId = this.serverId();
        result = result * 59 + (int)($serverId >>> 32 ^ $serverId);
        result = result * 59 + (this.nintendoLimited() ? 79 : 97);
        result = result * 59 + this.ipv4Port();
        result = result * 59 + this.ipv6Port();
        String $edition = this.edition();
        result = result * 59 + ($edition == null ? 43 : $edition.hashCode());
        String $motd = this.motd();
        result = result * 59 + ($motd == null ? 43 : $motd.hashCode());
        String $version = this.version();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $subMotd = this.subMotd();
        result = result * 59 + ($subMotd == null ? 43 : $subMotd.hashCode());
        String $gameType = this.gameType();
        result = result * 59 + ($gameType == null ? 43 : $gameType.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.extras());
        return result;
    }

    public String toString() {
        return "BedrockPong(edition=" + this.edition() + ", motd=" + this.motd() + ", protocolVersion=" + this.protocolVersion() + ", version=" + this.version() + ", playerCount=" + this.playerCount() + ", maximumPlayerCount=" + this.maximumPlayerCount() + ", serverId=" + this.serverId() + ", subMotd=" + this.subMotd() + ", gameType=" + this.gameType() + ", nintendoLimited=" + this.nintendoLimited() + ", ipv4Port=" + this.ipv4Port() + ", ipv6Port=" + this.ipv6Port() + ", extras=" + Arrays.deepToString(this.extras()) + ")";
    }
}

