/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.codec.compat.serializer;

import io.netty.buffer.ByteBuf;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import org.jose4j.json.internal.json_simple.JSONArray;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.jose4j.json.internal.json_simple.JSONValue;
import oxy.toviabedrock.shaded.fastutil.objects.ObjectArrayList;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockPacketSerializer;
import oxy.toviabedrock.shaded.protocol.bedrock.data.auth.CertificateChainPayload;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.LoginPacket;
import oxy.toviabedrock.shaded.protocol.common.util.Preconditions;
import oxy.toviabedrock.shaded.protocol.common.util.VarInts;

public class LoginSerializerCompat
implements BedrockPacketSerializer<LoginPacket> {
    public static final LoginSerializerCompat INSTANCE = new LoginSerializerCompat();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, LoginPacket packet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, LoginPacket packet) {
        packet.setProtocolVersion(buffer.readInt());
        ByteBuf jwt = buffer.readSlice(VarInts.readUnsignedInt(buffer));
        Object json = JSONValue.parse((String)this.readString(jwt).toString());
        Preconditions.checkArgument(json instanceof JSONObject && ((JSONObject)json).containsKey((Object)"chain"), "Invalid login chain");
        Object chain = ((JSONObject)json).get((Object)"chain");
        Preconditions.checkArgument(chain instanceof JSONArray, "Expected JSON array for login chain");
        ObjectArrayList<String> chainList = new ObjectArrayList<String>(3);
        for (Object node : (JSONArray)chain) {
            Preconditions.checkArgument(node instanceof String, "Expected String in login chain");
            chainList.add((String)node);
        }
        packet.setAuthPayload(new CertificateChainPayload(chainList));
        String value = (String)jwt.readCharSequence(jwt.readIntLE(), StandardCharsets.UTF_8);
        packet.setClientJwt(value);
    }

    protected AsciiString readString(ByteBuf buffer) {
        return (AsciiString)buffer.readCharSequence(buffer.readIntLE(), StandardCharsets.US_ASCII);
    }

    private LoginSerializerCompat() {
    }
}

