/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.codec.v291.serializer;

import io.netty.buffer.ByteBuf;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockPacketSerializer;
import oxy.toviabedrock.shaded.protocol.bedrock.data.SoundEvent;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.LevelSoundEvent1Packet;
import oxy.toviabedrock.shaded.protocol.common.util.TypeMap;
import oxy.toviabedrock.shaded.protocol.common.util.VarInts;

public class LevelSoundEvent1Serializer_v291
implements BedrockPacketSerializer<LevelSoundEvent1Packet> {
    private final TypeMap<SoundEvent> soundTypeMap;

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, LevelSoundEvent1Packet packet) {
        buffer.writeByte(this.soundTypeMap.getId(packet.getSound()));
        helper.writeVector3f(buffer, packet.getPosition());
        VarInts.writeInt(buffer, packet.getExtraData());
        VarInts.writeInt(buffer, packet.getPitch());
        buffer.writeBoolean(packet.isBabySound());
        buffer.writeBoolean(packet.isRelativeVolumeDisabled());
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, LevelSoundEvent1Packet packet) {
        packet.setSound(this.soundTypeMap.getType(buffer.readUnsignedByte()));
        packet.setPosition(helper.readVector3f(buffer));
        packet.setExtraData(VarInts.readInt(buffer));
        packet.setPitch(VarInts.readInt(buffer));
        packet.setBabySound(buffer.readBoolean());
        packet.setRelativeVolumeDisabled(buffer.readBoolean());
    }

    public LevelSoundEvent1Serializer_v291(TypeMap<SoundEvent> soundTypeMap) {
        this.soundTypeMap = soundTypeMap;
    }
}

