/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.codec.v361.serializer;

import io.netty.buffer.ByteBuf;
import oxy.toviabedrock.shaded.fastutil.longs.LongList;
import oxy.toviabedrock.shaded.fastutil.longs.LongListIterator;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockPacketSerializer;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.LevelChunkPacket;
import oxy.toviabedrock.shaded.protocol.common.util.VarInts;

public class LevelChunkSerializer_v361
implements BedrockPacketSerializer<LevelChunkPacket> {
    public static final LevelChunkSerializer_v361 INSTANCE = new LevelChunkSerializer_v361();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, LevelChunkPacket packet) {
        VarInts.writeInt(buffer, packet.getChunkX());
        VarInts.writeInt(buffer, packet.getChunkZ());
        VarInts.writeUnsignedInt(buffer, packet.getSubChunksLength());
        buffer.writeBoolean(packet.isCachingEnabled());
        if (packet.isCachingEnabled()) {
            LongList blobIds = packet.getBlobIds();
            VarInts.writeUnsignedInt(buffer, blobIds.size());
            LongListIterator longListIterator = blobIds.iterator();
            while (longListIterator.hasNext()) {
                long blobId = (Long)longListIterator.next();
                buffer.writeLongLE(blobId);
            }
        }
        helper.writeByteBuf(buffer, packet.getData());
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, LevelChunkPacket packet) {
        packet.setChunkX(VarInts.readInt(buffer));
        packet.setChunkZ(VarInts.readInt(buffer));
        packet.setSubChunksLength(VarInts.readUnsignedInt(buffer));
        packet.setCachingEnabled(buffer.readBoolean());
        if (packet.isCachingEnabled()) {
            LongList blobIds = packet.getBlobIds();
            int length = VarInts.readUnsignedInt(buffer);
            for (int i = 0; i < length; ++i) {
                blobIds.add(buffer.readLongLE());
            }
        }
        packet.setData(helper.readByteBuf(buffer));
    }

    protected LevelChunkSerializer_v361() {
    }
}

