/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.codec.v407;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import oxy.toviabedrock.shaded.fastutil.objects.ObjectArrayList;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.EntityDataTypeMap;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v390.BedrockCodecHelper_v390;
import oxy.toviabedrock.shaded.protocol.bedrock.data.definitions.ItemDefinition;
import oxy.toviabedrock.shaded.protocol.bedrock.data.entity.EntityLinkData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.ContainerSlotType;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.ItemData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.descriptor.DefaultDescriptor;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.descriptor.InvalidDescriptor;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.AutoCraftRecipeAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.BeaconPaymentAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.ConsumeAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.CraftCreativeAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.CraftNonImplementedAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.CraftRecipeAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.CraftResultsDeprecatedAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.CreateAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.DestroyAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.DropAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.LabTableCombineAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.PlaceAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.RecipeItemStackRequestAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.SwapAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.TakeAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.TransferItemStackRequestAction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseContainer;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseSlot;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.transaction.InventoryActionData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.transaction.InventorySource;
import oxy.toviabedrock.shaded.protocol.common.util.Preconditions;
import oxy.toviabedrock.shaded.protocol.common.util.TypeMap;
import oxy.toviabedrock.shaded.protocol.common.util.VarInts;

public class BedrockCodecHelper_v407
extends BedrockCodecHelper_v390 {
    protected final TypeMap<ItemStackRequestActionType> stackRequestActionTypes;
    protected final TypeMap<ContainerSlotType> containerSlotTypes;

    public BedrockCodecHelper_v407(EntityDataTypeMap entityData, TypeMap<Class<?>> gameRulesTypes, TypeMap<ItemStackRequestActionType> stackRequestActionTypes, TypeMap<ContainerSlotType> containerSlotTypes) {
        super(entityData, gameRulesTypes);
        this.stackRequestActionTypes = stackRequestActionTypes;
        this.containerSlotTypes = containerSlotTypes;
    }

    @Override
    public EntityLinkData readEntityLink(ByteBuf buffer) {
        return new EntityLinkData(VarInts.readLong(buffer), VarInts.readLong(buffer), EntityLinkData.Type.byId(buffer.readUnsignedByte()), buffer.readBoolean(), buffer.readBoolean());
    }

    @Override
    public void writeEntityLink(ByteBuf buffer, EntityLinkData entityLink) {
        Preconditions.checkNotNull(entityLink, "entityLink");
        VarInts.writeLong(buffer, entityLink.getFrom());
        VarInts.writeLong(buffer, entityLink.getTo());
        buffer.writeByte(entityLink.getType().ordinal());
        buffer.writeBoolean(entityLink.isImmediate());
        buffer.writeBoolean(entityLink.isRiderInitiated());
    }

    @Override
    public boolean readInventoryActions(ByteBuf buffer, List<InventoryActionData> actions) {
        boolean hasNetworkIds = buffer.readBoolean();
        this.readArray(buffer, actions, (ByteBuf buf, BedrockCodecHelper helper) -> {
            InventorySource source = this.readSource((ByteBuf)buf);
            int slot = VarInts.readUnsignedInt(buf);
            ItemData fromItem = helper.readItem((ByteBuf)buf);
            ItemData toItem = helper.readItem((ByteBuf)buf);
            int networkStackId = 0;
            if (hasNetworkIds) {
                networkStackId = VarInts.readInt(buf);
            }
            return new InventoryActionData(source, slot, fromItem, toItem, networkStackId);
        }, this.encodingSettings.maxInventoryActionsOrRequests());
        return hasNetworkIds;
    }

    @Override
    public void writeInventoryActions(ByteBuf buffer, List<InventoryActionData> actions, boolean hasNetworkIds) {
        buffer.writeBoolean(hasNetworkIds);
        this.writeArray(buffer, actions, (ByteBuf buf, BedrockCodecHelper helper, T action) -> {
            this.writeSource(buffer, action.getSource());
            VarInts.writeUnsignedInt(buffer, action.getSlot());
            helper.writeItem(buffer, action.getFromItem());
            helper.writeItem(buffer, action.getToItem());
            if (hasNetworkIds) {
                VarInts.writeInt(buffer, action.getStackNetworkId());
            }
        });
    }

    @Override
    public ItemData readNetItem(ByteBuf buffer) {
        int netId = VarInts.readInt(buffer);
        ItemData item = this.readItem(buffer);
        item.setNetId(netId);
        return item;
    }

    @Override
    public void writeNetItem(ByteBuf buffer, ItemData item) {
        VarInts.writeInt(buffer, item.getNetId());
        this.writeItem(buffer, item);
    }

    @Override
    public ItemStackRequest readItemStackRequest(ByteBuf buffer) {
        int requestId = VarInts.readInt(buffer);
        ObjectArrayList actions = new ObjectArrayList();
        this.readArray(buffer, actions, (ByteBuf byteBuf) -> {
            ItemStackRequestActionType type = this.stackRequestActionTypes.getType(byteBuf.readByte());
            return this.readRequestActionData((ByteBuf)byteBuf, type);
        }, 32);
        return new ItemStackRequest(requestId, actions.toArray(new ItemStackRequestAction[0]), new String[0]);
    }

    @Override
    public void writeItemStackRequest(ByteBuf buffer, ItemStackRequest request) {
        VarInts.writeInt(buffer, request.getRequestId());
        this.writeArray(buffer, request.getActions(), (ByteBuf byteBuf, T action) -> {
            ItemStackRequestActionType type = action.getType();
            byteBuf.writeByte(this.stackRequestActionTypes.getId(type));
            this.writeRequestActionData((ByteBuf)byteBuf, (ItemStackRequestAction)action);
        });
    }

    protected void writeRequestActionData(ByteBuf byteBuf, ItemStackRequestAction action) {
        switch (action.getType()) {
            case TAKE: 
            case PLACE: {
                byteBuf.writeByte(((TransferItemStackRequestAction)action).getCount());
                this.writeStackRequestSlotInfo(byteBuf, ((TransferItemStackRequestAction)action).getSource());
                this.writeStackRequestSlotInfo(byteBuf, ((TransferItemStackRequestAction)action).getDestination());
                break;
            }
            case SWAP: {
                this.writeStackRequestSlotInfo(byteBuf, ((SwapAction)action).getSource());
                this.writeStackRequestSlotInfo(byteBuf, ((SwapAction)action).getDestination());
                break;
            }
            case DROP: {
                byteBuf.writeByte(((DropAction)action).getCount());
                this.writeStackRequestSlotInfo(byteBuf, ((DropAction)action).getSource());
                byteBuf.writeBoolean(((DropAction)action).isRandomly());
                break;
            }
            case DESTROY: {
                byteBuf.writeByte(((DestroyAction)action).getCount());
                this.writeStackRequestSlotInfo(byteBuf, ((DestroyAction)action).getSource());
                break;
            }
            case CONSUME: {
                byteBuf.writeByte(((ConsumeAction)action).getCount());
                this.writeStackRequestSlotInfo(byteBuf, ((ConsumeAction)action).getSource());
                break;
            }
            case CREATE: {
                byteBuf.writeByte(((CreateAction)action).getSlot());
                break;
            }
            case LAB_TABLE_COMBINE: {
                break;
            }
            case BEACON_PAYMENT: {
                VarInts.writeInt(byteBuf, ((BeaconPaymentAction)action).getPrimaryEffect());
                VarInts.writeInt(byteBuf, ((BeaconPaymentAction)action).getSecondaryEffect());
                break;
            }
            case CRAFT_RECIPE: 
            case CRAFT_RECIPE_AUTO: {
                VarInts.writeUnsignedInt(byteBuf, ((RecipeItemStackRequestAction)action).getRecipeNetworkId());
                break;
            }
            case CRAFT_CREATIVE: {
                VarInts.writeUnsignedInt(byteBuf, ((CraftCreativeAction)action).getCreativeItemNetworkId());
                break;
            }
            case CRAFT_NON_IMPLEMENTED_DEPRECATED: {
                break;
            }
            case CRAFT_RESULTS_DEPRECATED: {
                this.writeArray(byteBuf, ((CraftResultsDeprecatedAction)action).getResultItems(), (ByteBuf buf2, T item) -> this.writeItem((ByteBuf)buf2, (ItemData)item));
                byteBuf.writeByte(((CraftResultsDeprecatedAction)action).getTimesCrafted());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unhandled stack request action type: " + (Object)((Object)action.getType()));
            }
        }
    }

    protected ItemStackRequestAction readRequestActionData(ByteBuf byteBuf, ItemStackRequestActionType type) {
        switch (type) {
            case TAKE: {
                return new TakeAction(byteBuf.readUnsignedByte(), this.readStackRequestSlotInfo(byteBuf), this.readStackRequestSlotInfo(byteBuf));
            }
            case PLACE: {
                return new PlaceAction(byteBuf.readUnsignedByte(), this.readStackRequestSlotInfo(byteBuf), this.readStackRequestSlotInfo(byteBuf));
            }
            case SWAP: {
                return new SwapAction(this.readStackRequestSlotInfo(byteBuf), this.readStackRequestSlotInfo(byteBuf));
            }
            case DROP: {
                return new DropAction(byteBuf.readUnsignedByte(), this.readStackRequestSlotInfo(byteBuf), byteBuf.readBoolean());
            }
            case DESTROY: {
                return new DestroyAction(byteBuf.readUnsignedByte(), this.readStackRequestSlotInfo(byteBuf));
            }
            case CONSUME: {
                return new ConsumeAction(byteBuf.readUnsignedByte(), this.readStackRequestSlotInfo(byteBuf));
            }
            case CREATE: {
                return new CreateAction(byteBuf.readUnsignedByte());
            }
            case LAB_TABLE_COMBINE: {
                return new LabTableCombineAction();
            }
            case BEACON_PAYMENT: {
                return new BeaconPaymentAction(VarInts.readInt(byteBuf), VarInts.readInt(byteBuf));
            }
            case CRAFT_RECIPE: {
                return new CraftRecipeAction(VarInts.readUnsignedInt(byteBuf), 0);
            }
            case CRAFT_RECIPE_AUTO: {
                return new AutoCraftRecipeAction(VarInts.readUnsignedInt(byteBuf), 0, Collections.emptyList(), 0);
            }
            case CRAFT_CREATIVE: {
                return new CraftCreativeAction(VarInts.readUnsignedInt(byteBuf), 0);
            }
            case CRAFT_NON_IMPLEMENTED_DEPRECATED: {
                return new CraftNonImplementedAction();
            }
            case CRAFT_RESULTS_DEPRECATED: {
                return new CraftResultsDeprecatedAction(this.readArray(byteBuf, new ItemData[0], this::readItem), byteBuf.readUnsignedByte());
            }
        }
        throw new UnsupportedOperationException("Unhandled stack request action type: " + (Object)((Object)type));
    }

    protected ItemStackRequestSlotData readStackRequestSlotInfo(ByteBuf buffer) {
        return new ItemStackRequestSlotData(this.readContainerSlotType(buffer), buffer.readUnsignedByte(), VarInts.readInt(buffer), null);
    }

    protected void writeStackRequestSlotInfo(ByteBuf buffer, ItemStackRequestSlotData data) {
        this.writeContainerSlotType(buffer, data.getContainer());
        buffer.writeByte(data.getSlot());
        VarInts.writeInt(buffer, data.getStackNetworkId());
    }

    @Override
    public ContainerSlotType readContainerSlotType(ByteBuf buffer) {
        return this.containerSlotTypes.getType(buffer.readByte());
    }

    @Override
    public void writeContainerSlotType(ByteBuf buffer, ContainerSlotType slotType) {
        buffer.writeByte(this.containerSlotTypes.getId(slotType));
    }

    @Override
    public ItemDescriptorWithCount readIngredient(ByteBuf buffer) {
        int runtimeId = VarInts.readInt(buffer);
        if (runtimeId == 0) {
            return ItemDescriptorWithCount.EMPTY;
        }
        ItemDefinition definition = this.getItemDefinitions().getDefinition(runtimeId);
        int meta = this.fromAuxValue(VarInts.readInt(buffer));
        int count = VarInts.readInt(buffer);
        return new ItemDescriptorWithCount(new DefaultDescriptor(definition, meta), count);
    }

    @Override
    public void writeIngredient(ByteBuf buffer, ItemDescriptorWithCount ingredient) {
        Objects.requireNonNull(ingredient, "ingredient is null");
        if (ingredient == ItemDescriptorWithCount.EMPTY || ingredient.getDescriptor() == InvalidDescriptor.INSTANCE) {
            VarInts.writeInt(buffer, 0);
            return;
        }
        Preconditions.checkArgument(ingredient.getDescriptor() instanceof DefaultDescriptor, "Descriptor must be of type DefaultDescriptor");
        DefaultDescriptor descriptor = (DefaultDescriptor)ingredient.getDescriptor();
        VarInts.writeInt(buffer, descriptor.getItemId().getRuntimeId());
        VarInts.writeInt(buffer, this.toAuxValue(descriptor.getAuxValue()));
        VarInts.writeInt(buffer, ingredient.getCount());
    }

    @Override
    public void writeItemStackResponseContainer(ByteBuf buffer, ItemStackResponseContainer container) {
        this.writeContainerSlotType(buffer, container.getContainer());
        this.writeArray(buffer, container.getItems(), this::writeItemEntry);
    }

    @Override
    public ItemStackResponseContainer readItemStackResponseContainer(ByteBuf buffer) {
        ContainerSlotType slotType = this.readContainerSlotType(buffer);
        ArrayList<ItemStackResponseSlot> itemEntries = new ArrayList<ItemStackResponseSlot>();
        this.readArray(buffer, itemEntries, this::readItemEntry);
        return new ItemStackResponseContainer(slotType, itemEntries, null);
    }

    protected ItemStackResponseSlot readItemEntry(ByteBuf buffer) {
        return new ItemStackResponseSlot(buffer.readUnsignedByte(), buffer.readUnsignedByte(), buffer.readUnsignedByte(), VarInts.readInt(buffer), "", 0, "");
    }

    protected void writeItemEntry(ByteBuf buffer, ItemStackResponseSlot itemEntry) {
        buffer.writeByte(itemEntry.getSlot());
        buffer.writeByte(itemEntry.getHotbarSlot());
        buffer.writeByte(itemEntry.getCount());
        VarInts.writeInt(buffer, itemEntry.getStackNetworkId());
    }

    protected int fromAuxValue(int value) {
        return value == Short.MAX_VALUE ? -1 : value;
    }

    protected int toAuxValue(int value) {
        return value == -1 ? Short.MAX_VALUE : value;
    }
}

